/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.domain;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Link;
import org.onosproject.net.domain.DomainPointToPointIntent;
import org.onosproject.net.intent.ConnectivityIntentTest;
import org.onosproject.net.provider.ProviderId;

public class DomainPointToPointIntentTest
extends ConnectivityIntentTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final Link L1 = DefaultLink.builder().providerId(PID).src(FP1.connectPoint()).dst(FP2.connectPoint()).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
    private static final List<Link> LINKS_SET = new LinkedList<Link>(Arrays.asList(L1));

    @Test
    public void basics() {
        DomainPointToPointIntent intent = this.createOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect ingress", (long)intent.filteredIngressPoints().size(), (long)1L);
        Assert.assertEquals((String)"incorrect ingress", intent.filteredIngressPoints().iterator().next(), (Object)FP1);
        Assert.assertEquals((String)"incorrect ingress", (long)intent.filteredEgressPoints().size(), (long)1L);
        Assert.assertEquals((String)"incorrect ingress", intent.filteredEgressPoints().iterator().next(), (Object)FP2);
        Assert.assertEquals((long)intent.links().size(), (long)0L);
    }

    @Test
    public void links() {
        DomainPointToPointIntent intent = this.createAnother();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect ingress", (long)intent.filteredIngressPoints().size(), (long)1L);
        Assert.assertEquals((String)"incorrect ingress", intent.filteredIngressPoints().iterator().next(), (Object)FP2);
        Assert.assertEquals((String)"incorrect ingress", (long)intent.filteredEgressPoints().size(), (long)1L);
        Assert.assertEquals((String)"incorrect ingress", intent.filteredEgressPoints().iterator().next(), (Object)FP1);
        Assert.assertEquals((String)"links are not correctly assigned", (Object)intent.links(), LINKS_SET);
        Assert.assertEquals((String)"resources are not correctly assigned", (Object)intent.resources(), (Object)DomainPointToPointIntent.resources(LINKS_SET));
    }

    protected DomainPointToPointIntent createOne() {
        return DomainPointToPointIntent.builder().appId(APPID).filteredIngressPoint(FP1).filteredEgressPoint(FP2).links((List)ImmutableList.of()).build();
    }

    protected DomainPointToPointIntent createAnother() {
        return DomainPointToPointIntent.builder().appId(APPID).filteredIngressPoint(FP2).filteredEgressPoint(FP1).links(LINKS_SET).build();
    }
}

