/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.onosproject.cluster.Leader;
import org.onosproject.cluster.NodeId;

public class Leadership {
    private final String topic;
    private final Leader leader;
    private final List<NodeId> candidates;

    public Leadership(String topic, Leader leader, List<NodeId> candidates) {
        this.topic = topic;
        this.leader = leader;
        this.candidates = ImmutableList.copyOf(candidates);
    }

    public String topic() {
        return this.topic;
    }

    public NodeId leaderNodeId() {
        return this.leader == null ? null : this.leader.nodeId();
    }

    public Leader leader() {
        return this.leader;
    }

    public List<NodeId> candidates() {
        return this.candidates;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.leader, this.candidates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Leadership) {
            Leadership other = (Leadership)obj;
            return Objects.equals(this.topic, other.topic) && Objects.equals(this.leader, other.leader) && Objects.equals(this.candidates, other.candidates);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("topic", (Object)this.topic).add("leader", (Object)this.leader).add("candidates", this.candidates).toString();
    }
}

