/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.inbandtelemetry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.net.behaviour.inbandtelemetry.IntMetadataType;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;

public final class IntObjective {
    private static final int DEFAULT_PRIORITY = 10;
    private final TrafficSelector selector;
    private final ImmutableSet<IntMetadataType> metadataTypes;

    private IntObjective(TrafficSelector selector, Set<IntMetadataType> metadataTypes) {
        this.selector = selector;
        this.metadataTypes = ImmutableSet.copyOf(metadataTypes);
    }

    public TrafficSelector selector() {
        return this.selector;
    }

    public Set<IntMetadataType> metadataTypes() {
        return this.metadataTypes;
    }

    public static final class Builder {
        private TrafficSelector selector = DefaultTrafficSelector.emptySelector();
        private final Set<IntMetadataType> metadataTypes = new HashSet<IntMetadataType>();

        public Builder withSelector(TrafficSelector selector) {
            this.selector = selector;
            return this;
        }

        public Builder withMetadataTypes(Set<IntMetadataType> metadataTypes) {
            this.metadataTypes.addAll(metadataTypes);
            return this;
        }

        public IntObjective build() {
            Preconditions.checkArgument((!this.selector.criteria().isEmpty() ? 1 : 0) != 0, (Object)"Empty selector cannot match any flow.");
            Preconditions.checkArgument((!this.metadataTypes.isEmpty() ? 1 : 0) != 0, (Object)"Metadata types cannot be empty");
            return new IntObjective(this.selector, this.metadataTypes);
        }
    }
}

