/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.onlab.util.Identifier;

@Beta
public final class PolicerId
extends Identifier<String> {
    public static final PolicerId NONE = PolicerId.policerId("none:none");
    private static final int POLICER_ID_MAX_LENGTH = 1024;
    private final URI uri;

    private PolicerId(URI u) {
        super((Object)u.toString());
        this.uri = u;
    }

    private PolicerId() {
        this.uri = null;
    }

    public static PolicerId policerId(URI uri) {
        return new PolicerId(uri);
    }

    public static PolicerId policerId(String string) {
        Preconditions.checkArgument((string.length() <= 1024 ? 1 : 0) != 0, (Object)"URI string exceeds maximum length 1024");
        return PolicerId.policerId(URI.create(string));
    }

    public URI uri() {
        return this.uri;
    }
}

