/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.VlanId;
import org.onosproject.net.flow.criteria.Criterion;

public final class VlanIdCriterion
implements Criterion {
    private final VlanId vlanId;
    private final Criterion.Type type;

    VlanIdCriterion(VlanId vlanId) {
        this.vlanId = vlanId;
        this.type = Criterion.Type.VLAN_VID;
    }

    VlanIdCriterion(VlanId vlanId, Criterion.Type type) {
        Preconditions.checkArgument((type == Criterion.Type.INNER_VLAN_VID || type == Criterion.Type.VLAN_VID ? 1 : 0) != 0, (Object)"Type can only be inner vlan or vlan");
        this.vlanId = vlanId;
        this.type = type;
    }

    @Override
    public Criterion.Type type() {
        return this.type;
    }

    public VlanId vlanId() {
        return this.vlanId;
    }

    public String toString() {
        return this.type().toString() + ":" + this.vlanId;
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.vlanId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VlanIdCriterion) {
            VlanIdCriterion that = (VlanIdCriterion)obj;
            return Objects.equals(this.vlanId, that.vlanId) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

