/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.ui.topo.BiLink;
import org.onosproject.ui.topo.TopoUtils;

public abstract class BiLinkMap<B extends BiLink> {
    private final Map<LinkKey, B> map = new HashMap<LinkKey, B>();

    protected abstract B create(LinkKey var1, Link var2);

    public B add(Link link) {
        LinkKey key = TopoUtils.canonicalLinkKey((Link)Preconditions.checkNotNull((Object)link));
        BiLink blink = (BiLink)this.map.get(key);
        if (blink == null) {
            blink = this.create(key, link);
            this.map.put(key, blink);
        } else if (!blink.one().equals(link)) {
            blink.setOther(link);
        }
        return (B)blink;
    }

    public Collection<B> biLinks() {
        return this.map.values();
    }

    public int size() {
        return this.map.size();
    }
}

