/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.alarm;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.alarm.AlarmId;
import org.onosproject.net.DeviceId;

public class AlarmIdTest {
    private static final DeviceId DEVICE_ID = DeviceId.deviceId((String)"foo:bar");
    private static final String UNIQUE_ID_1 = "unique_id_1";
    private static final AlarmId ID_A = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)"unique_id_1");
    private static final String UNIQUE_ID_2 = "unique_id_2";
    private static final String UNIQUE_ID_3 = "unique_id_3";
    private static final AlarmId ID_Z = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)"unique_id_3");
    private static final String ID_STRING = "foo:bar:unique_id_3";

    @Test
    public void intentIdFollowsGuidelineForImmutableObject() {
        ImmutableClassChecker.assertThatClassIsImmutable(AlarmId.class);
    }

    @Test
    public void testEquality() {
        AlarmId id1 = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)UNIQUE_ID_1);
        AlarmId id2 = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)UNIQUE_ID_1);
        Assert.assertThat((Object)id1, (Matcher)Matchers.is((Object)id2));
    }

    @Test
    public void testNonEquality() {
        AlarmId id1 = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)UNIQUE_ID_1);
        AlarmId id2 = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)UNIQUE_ID_2);
        Assert.assertThat((Object)id1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)id2)));
    }

    @Test
    public void valueOf() {
        AlarmId id = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)UNIQUE_ID_1);
        Assert.assertEquals((String)"incorrect valueOf", (Object)id, (Object)ID_A);
    }

    @Test
    public void testEquals() {
        AlarmId id1 = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)UNIQUE_ID_1);
        AlarmId sameAsId1 = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)UNIQUE_ID_1);
        AlarmId id2 = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)UNIQUE_ID_2);
        new EqualsTester().addEqualityGroup(new Object[]{id1, sameAsId1}).addEqualityGroup(new Object[]{id2}).testEquals();
    }

    @Test
    public void testConstruction() {
        AlarmId id1 = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)UNIQUE_ID_3);
        Assert.assertEquals((Object)id1.toString(), (Object)ID_Z.toString());
        AlarmId idString = AlarmId.alarmId((String)ID_STRING);
        Assert.assertEquals((Object)id1, (Object)idString);
    }
}

