/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.Node;
import org.onosproject.cluster.Partition;
import org.onosproject.net.Provided;
import org.onosproject.net.provider.ProviderId;

public final class ClusterMetadata
implements Provided {
    private static final ProviderId NONE_PROVIDER_ID = new ProviderId("none", "none");
    private static final String DEFAULT_CLUSTER_SECRET = "INSECURE!";
    private final ProviderId providerId;
    private final String name;
    private final ControllerNode localNode;
    private final Set<ControllerNode> controllerNodes;
    private final String storageDnsService;
    private final Set<Node> storageNodes;
    private final String clusterSecret;
    public static final Funnel<ClusterMetadata> HASH_FUNNEL = new Funnel<ClusterMetadata>(){

        public void funnel(ClusterMetadata cm, PrimitiveSink into) {
            into.putString((CharSequence)cm.name, Charsets.UTF_8);
        }
    };

    private ClusterMetadata() {
        this.providerId = null;
        this.name = null;
        this.localNode = null;
        this.controllerNodes = null;
        this.storageDnsService = null;
        this.storageNodes = null;
        this.clusterSecret = null;
    }

    @Deprecated
    public ClusterMetadata(ProviderId providerId, String name, ControllerNode localNode, Set<ControllerNode> controllerNodes, String storageDnsService, Set<Node> storageNodes) {
        this(providerId, name, localNode, controllerNodes, storageDnsService, storageNodes, DEFAULT_CLUSTER_SECRET);
    }

    public ClusterMetadata(ProviderId providerId, String name, ControllerNode localNode, Set<ControllerNode> controllerNodes, Set<Node> storageNodes, String clusterSecret) {
        this(providerId, name, localNode, controllerNodes, null, storageNodes, clusterSecret);
    }

    public ClusterMetadata(ProviderId providerId, String name, ControllerNode localNode, Set<ControllerNode> controllerNodes, String storageDnsService, Set<Node> storageNodes, String clusterSecret) {
        this.providerId = (ProviderId)Preconditions.checkNotNull((Object)providerId);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.localNode = localNode;
        this.controllerNodes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(controllerNodes)));
        this.storageDnsService = storageDnsService;
        this.storageNodes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(storageNodes)));
        this.clusterSecret = clusterSecret;
    }

    @Deprecated
    public ClusterMetadata(String name, ControllerNode localNode, Set<ControllerNode> controllerNodes, Set<Node> storageNodes) {
        this(NONE_PROVIDER_ID, name, localNode, controllerNodes, null, storageNodes, DEFAULT_CLUSTER_SECRET);
    }

    public ClusterMetadata(String name, ControllerNode localNode, Set<ControllerNode> controllerNodes, Set<Node> storageNodes, String clusterSecret) {
        this(NONE_PROVIDER_ID, name, localNode, controllerNodes, null, storageNodes, clusterSecret);
    }

    @Override
    public ProviderId providerId() {
        return this.providerId;
    }

    public String getName() {
        return this.name;
    }

    public String getStorageDnsService() {
        return this.storageDnsService;
    }

    public ControllerNode getLocalNode() {
        return this.localNode;
    }

    @Deprecated
    public Collection<ControllerNode> getNodes() {
        return this.getControllerNodes();
    }

    public Collection<ControllerNode> getControllerNodes() {
        return this.controllerNodes;
    }

    public Collection<Node> getStorageNodes() {
        return this.storageNodes;
    }

    @Deprecated
    public Collection<Partition> getPartitions() {
        return Collections.emptySet();
    }

    public String getClusterSecret() {
        return this.clusterSecret;
    }

    public String toString() {
        return MoreObjects.toStringHelper(ClusterMetadata.class).add("providerId", (Object)this.providerId).add("name", (Object)this.name).add("controllerNodes", this.controllerNodes).add("storageNodes", this.storageNodes).toString();
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.providerId, this.name, this.controllerNodes, this.storageNodes});
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!ClusterMetadata.class.isInstance(object)) {
            return false;
        }
        ClusterMetadata that = (ClusterMetadata)object;
        return Objects.equals(this.name, that.name) && this.localNode.equals(that.localNode) && Objects.equals(this.controllerNodes.size(), that.controllerNodes.size()) && Sets.symmetricDifference(this.controllerNodes, that.controllerNodes).isEmpty() && Objects.equals(this.storageNodes.size(), that.storageNodes.size()) && Sets.symmetricDifference(this.storageNodes, that.storageNodes).isEmpty();
    }
}

