/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.inbandtelemetry;

import com.google.common.annotations.Beta;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;
import org.onosproject.ui.JsonUtils;

@Beta
public final class IntReportConfig
extends Config<ApplicationId> {
    private static final String COLLECTOR_IP = "collectorIp";
    private static final String COLLECTOR_PORT = "collectorPort";
    private static final String MIN_FLOW_HOP_LATENCY_CHANGE_NS = "minFlowHopLatencyChangeNs";
    private static final String COLLECTOR_NEXT_HOP_MAC = "collectorNextHopMac";
    private static final String SINK_IP = "sinkIp";
    private static final String SINK_MAC = "sinkMac";

    public IpAddress collectorIp() {
        if (this.object.hasNonNull(COLLECTOR_IP)) {
            return IpAddress.valueOf((String)JsonUtils.string(this.object, COLLECTOR_IP));
        }
        return null;
    }

    public TpPort collectorPort() {
        if (this.object.hasNonNull(COLLECTOR_PORT)) {
            return TpPort.tpPort((int)((int)JsonUtils.number(this.object, COLLECTOR_PORT)));
        }
        return null;
    }

    public int minFlowHopLatencyChangeNs() {
        if (this.object.hasNonNull(MIN_FLOW_HOP_LATENCY_CHANGE_NS)) {
            return (int)JsonUtils.number(this.object, MIN_FLOW_HOP_LATENCY_CHANGE_NS);
        }
        return 0;
    }

    public MacAddress collectorNextHopMac() {
        if (this.object.hasNonNull(COLLECTOR_NEXT_HOP_MAC)) {
            return MacAddress.valueOf((String)JsonUtils.string(this.object, COLLECTOR_NEXT_HOP_MAC));
        }
        return null;
    }

    public IpAddress sinkIp() {
        if (this.object.hasNonNull(SINK_IP)) {
            return IpAddress.valueOf((String)JsonUtils.string(this.object, SINK_IP));
        }
        return null;
    }

    public MacAddress sinkMac() {
        if (this.object.hasNonNull(SINK_MAC)) {
            return MacAddress.valueOf((String)JsonUtils.string(this.object, SINK_MAC));
        }
        return null;
    }

    public IntReportConfig setCollectorIp(IpAddress collectorIp) {
        return (IntReportConfig)this.setOrClear(COLLECTOR_IP, collectorIp.toString());
    }

    public IntReportConfig setCollectorPort(TpPort port) {
        return (IntReportConfig)this.setOrClear(COLLECTOR_PORT, port.toInt());
    }

    public IntReportConfig setMinFlowHopLatencyChangeNs(int ns) {
        return (IntReportConfig)this.setOrClear(MIN_FLOW_HOP_LATENCY_CHANGE_NS, ns);
    }

    public IntReportConfig setCollectorNextHopMac(MacAddress collectorNextHopMac) {
        return (IntReportConfig)this.setOrClear(COLLECTOR_NEXT_HOP_MAC, collectorNextHopMac.toString());
    }

    public IntReportConfig setSinkIp(IpAddress sinkIp) {
        return (IntReportConfig)this.setOrClear(SINK_IP, sinkIp.toString());
    }

    public IntReportConfig setSinkMac(MacAddress sinkMac) {
        return (IntReportConfig)this.setOrClear(SINK_MAC, sinkMac.toString());
    }
}

