/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Beta
public final class PointToPointIntent
extends ConnectivityIntent {
    private final FilteredConnectPoint ingressPoint;
    private final FilteredConnectPoint egressPoint;
    private final List<Link> suggestedPath;

    public static Builder builder() {
        return new Builder();
    }

    private PointToPointIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, FilteredConnectPoint ingressPoint, FilteredConnectPoint egressPoint, List<Constraint> constraints, int priority, List<Link> suggestedPath, ResourceGroup resourceGroup) {
        super(appId, key, suggestedPath != null ? PointToPointIntent.resources(suggestedPath) : Collections.emptyList(), selector, treatment, constraints, priority, resourceGroup);
        Preconditions.checkArgument((!ingressPoint.equals(egressPoint) ? 1 : 0) != 0, (String)"ingress and egress should be different (ingress: %s, egress: %s)", (Object)ingressPoint, (Object)egressPoint);
        this.ingressPoint = (FilteredConnectPoint)Preconditions.checkNotNull((Object)ingressPoint);
        this.egressPoint = (FilteredConnectPoint)Preconditions.checkNotNull((Object)egressPoint);
        this.suggestedPath = suggestedPath;
    }

    protected PointToPointIntent() {
        this.ingressPoint = null;
        this.egressPoint = null;
        this.suggestedPath = null;
    }

    public FilteredConnectPoint filteredIngressPoint() {
        return this.ingressPoint;
    }

    public FilteredConnectPoint filteredEgressPoint() {
        return this.egressPoint;
    }

    public List<Link> suggestedPath() {
        return this.suggestedPath;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingress", (Object)this.filteredIngressPoint()).add("egress", (Object)this.filteredEgressPoint()).add("constraints", this.constraints()).add("links", this.suggestedPath()).add("resourceGroup", (Object)this.resourceGroup()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        FilteredConnectPoint ingressPoint;
        FilteredConnectPoint egressPoint;
        List<Link> suggestedPath;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Override
        public Builder resourceGroup(ResourceGroup resourceGroup) {
            return (Builder)super.resourceGroup(resourceGroup);
        }

        public Builder filteredIngressPoint(FilteredConnectPoint ingressPoint) {
            this.ingressPoint = ingressPoint;
            return this;
        }

        public Builder filteredEgressPoint(FilteredConnectPoint egressPoint) {
            this.egressPoint = egressPoint;
            return this;
        }

        public Builder suggestedPath(List<Link> links) {
            this.suggestedPath = links;
            return this;
        }

        public PointToPointIntent build() {
            if (!(this.suggestedPath == null || this.suggestedPath.size() <= 0 || this.suggestedPath.get(0).src().deviceId().equals(this.ingressPoint.connectPoint().deviceId()) && this.suggestedPath.get(this.suggestedPath.size() - 1).dst().deviceId().equals(this.egressPoint.connectPoint().deviceId()))) {
                throw new IllegalArgumentException("Suggested path not compatible with ingress and egress connect points");
            }
            return new PointToPointIntent(this.appId, this.key, this.selector, this.treatment, this.ingressPoint, this.egressPoint, this.constraints, this.priority, this.suggestedPath, this.resourceGroup);
        }
    }
}

