/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.ControllerNodeToNodeId;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;

public class ControllerNodeToNodeIdTest {
    private static final NodeId NID1 = new NodeId("foo");
    private static final NodeId NID2 = new NodeId("bar");
    private static final NodeId NID3 = new NodeId("buz");
    private static final IpAddress IP1 = IpAddress.valueOf((String)"127.0.0.1");
    private static final IpAddress IP2 = IpAddress.valueOf((String)"127.0.0.2");
    private static final IpAddress IP3 = IpAddress.valueOf((String)"127.0.0.3");
    private static final ControllerNode CN1 = new DefaultControllerNode(NID1, IP1);
    private static final ControllerNode CN2 = new DefaultControllerNode(NID2, IP2);
    private static final ControllerNode CN3 = new DefaultControllerNode(NID3, IP3);

    @Test
    public final void testToNodeId() {
        List<ControllerNode> nodes = Arrays.asList(CN1, CN2, CN3, null);
        List<NodeId> nodeIds = Arrays.asList(NID1, NID2, NID3);
        Assert.assertEquals(nodeIds, (Object)FluentIterable.from(nodes).transform((Function)ControllerNodeToNodeId.toNodeId()).filter(Predicates.notNull()).toList());
    }
}

