/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.DscpClass;
import org.onlab.util.Bandwidth;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.BandwidthProfile;
import org.onosproject.net.behaviour.BandwidthProfileAction;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeter;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterId;

public class BandwidthProfileTest {
    private static final long ONE = 1L;
    private static final long ONE_K = 1000L;
    private static final long TWO_K = 2000L;
    private static final long EIGHT_K = 8000L;
    private static final long ONE_M = 1000000L;
    private static final long TEN_M = 10000000L;

    @Test
    public void testMeterConversion() {
        DeviceId deviceId = DeviceId.deviceId((String)"netconf:10.0.0.1:22");
        ApplicationId appId = TestApplicationId.create("org.onosproject.foo.app");
        Meter.Builder meterBuilder = new DefaultMeter.Builder().withId(MeterId.meterId((long)1L)).withUnit(Meter.Unit.KB_PER_SEC).forDevice(deviceId).burst();
        Band band1 = DefaultBand.builder().ofType(Band.Type.DROP).withRate(10000000L).burstSize(2000L).build();
        Meter meter = meterBuilder.fromApp(appId).withBands(Arrays.asList(band1)).build();
        BandwidthProfile bandwidthProfile = BandwidthProfile.fromMeter((Meter)meter);
        Assert.assertEquals((String)"wrong bw profile name", (Object)bandwidthProfile.name(), (Object)meter.id().toString());
        Assert.assertEquals((String)"wrong bw profile type", (Object)bandwidthProfile.type(), (Object)BandwidthProfile.Type.sr2CM);
        Assert.assertEquals((String)"wrong bw profile CIR", (double)bandwidthProfile.cir().bps(), (double)(band1.rate() * 8000L), (double)0.0);
        Assert.assertEquals((String)"wrong bw profile CBS", (long)bandwidthProfile.cbs().intValue(), (long)band1.burst());
        Assert.assertNull((Object)bandwidthProfile.pir());
        Assert.assertNull((Object)bandwidthProfile.pbs());
        Assert.assertNull((Object)bandwidthProfile.ebs());
        Assert.assertEquals((String)"wrong green action", (Object)bandwidthProfile.greenAction(), (Object)BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.PASS).build());
        Assert.assertNull((Object)bandwidthProfile.yellowAction());
        Assert.assertEquals((String)"wrong red action", (Object)bandwidthProfile.redAction(), (Object)BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.DISCARD).build());
        Assert.assertEquals((String)"wrong color-aware mode", (Object)bandwidthProfile.colorAware(), (Object)false);
        Band band2 = DefaultBand.builder().burstSize(1000L).ofType(Band.Type.REMARK).dropPrecedence((short)10).withRate(1000000L).build();
        meter = meterBuilder.fromApp(appId).withBands(Arrays.asList(band1, band2)).build();
        bandwidthProfile = BandwidthProfile.fromMeter((Meter)meter);
        Assert.assertEquals((String)"wrong bw profile name", (Object)bandwidthProfile.name(), (Object)meter.id().toString());
        Assert.assertEquals((String)"wrong bw profile type", (Object)bandwidthProfile.type(), (Object)BandwidthProfile.Type.trTCM);
        Assert.assertEquals((String)"wrong bw profile CIR", (double)bandwidthProfile.cir().bps(), (double)(band2.rate() * 8000L), (double)0.0);
        Assert.assertEquals((String)"wrong bw profile CBS", (long)bandwidthProfile.cbs().intValue(), (long)band2.burst());
        Assert.assertEquals((String)"wrong bw profile PIR", (double)bandwidthProfile.pir().bps(), (double)(band1.rate() * 8000L), (double)0.0);
        Assert.assertEquals((String)"wrong bw profile PBS", (long)bandwidthProfile.pbs().intValue(), (long)band1.burst());
        Assert.assertNull((Object)bandwidthProfile.ebs());
        Assert.assertEquals((String)"wrong green action", (Object)bandwidthProfile.greenAction(), (Object)BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.PASS).build());
        Assert.assertEquals((String)"wrong yellow action", (Object)bandwidthProfile.yellowAction(), (Object)BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.REMARK).dscpClass(DscpClass.AF11).build());
        Assert.assertEquals((String)"wrong red action", (Object)bandwidthProfile.redAction(), (Object)BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.DISCARD).build());
        Assert.assertEquals((String)"wrong color-aware mode", (Object)bandwidthProfile.colorAware(), (Object)false);
    }

    @Test
    public void testType() {
        BandwidthProfile.Builder bwProfileBuilder = BandwidthProfile.builder().name("profile").cir(Bandwidth.bps((long)1000000L)).cbs(Integer.valueOf(1000)).greenAction(BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.PASS).build()).redAction(BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.DISCARD).build()).colorAware(false);
        Assert.assertEquals((String)"wrong bw profile type", (Object)bwProfileBuilder.build().type(), (Object)BandwidthProfile.Type.sr2CM);
        bwProfileBuilder.ebs(Integer.valueOf(2000)).yellowAction(BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.REMARK).dscpClass(DscpClass.AF11).build());
        Assert.assertEquals((String)"wrong bw profile type", (Object)bwProfileBuilder.build().type(), (Object)BandwidthProfile.Type.srTCM);
        bwProfileBuilder.ebs(null);
        bwProfileBuilder.pir(Bandwidth.bps((long)10000000L)).pbs(Integer.valueOf(2000));
        Assert.assertEquals((String)"wrong bw profile type", (Object)bwProfileBuilder.build().type(), (Object)BandwidthProfile.Type.trTCM);
    }

    @Test
    public void testEquals() {
        BandwidthProfile bwProfile1 = new BandwidthProfile.Builder().name("profile1").cir(Bandwidth.bps((long)1000000L)).cbs(Integer.valueOf(1000)).pir(Bandwidth.bps((long)10000000L)).pbs(Integer.valueOf(2000)).greenAction(BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.PASS).build()).yellowAction(BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.REMARK).dscpClass(DscpClass.AF11).build()).redAction(BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.DISCARD).build()).colorAware(false).build();
        BandwidthProfile bwProfile2 = new BandwidthProfile.Builder().name("profile2").cir(Bandwidth.bps((long)1000000L)).cbs(Integer.valueOf(1000)).pir(Bandwidth.bps((long)10000000L)).pbs(Integer.valueOf(2000)).greenAction(BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.PASS).build()).yellowAction(BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.REMARK).dscpClass(DscpClass.AF11).build()).redAction(BandwidthProfileTest.getBuilder(BandwidthProfileAction.Action.DISCARD).build()).colorAware(false).build();
        Assert.assertTrue((String)"wrong equals method", (boolean)bwProfile1.equals((Object)bwProfile2));
    }

    private static BandwidthProfileAction.Builder getBuilder(BandwidthProfileAction.Action action) {
        return new BandwidthProfileAction.Builder().action(action);
    }
}

