/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.intent.ConnectivityIntentTest;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;

public class SinglePointToMultiPointIntentTest
extends ConnectivityIntentTest {
    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(SinglePointToMultiPointIntent.class);
    }

    @Test
    public void basics() {
        SinglePointToMultiPointIntent intent = this.createOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.ingressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)PS2, (Object)intent.egressPoints());
        intent = this.createAnother();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P2, (Object)intent.ingressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)PS1, (Object)intent.egressPoints());
        intent = this.createWithResourceGroup();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P2, (Object)intent.ingressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)PS1, (Object)intent.egressPoints());
        Assert.assertEquals((String)"incorrect resource group", (Object)RESOURCE_GROUP, (Object)intent.resourceGroup());
    }

    @Test
    public void filteredIntent() {
        SinglePointToMultiPointIntent intent = this.createFilteredOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect filtered ingress", (Object)FP2, (Object)intent.filteredIngressPoint());
        Assert.assertEquals((String)"incorrect filtered egress", (Object)FPS1, (Object)intent.filteredEgressPoints());
        intent = this.createAnotherFiltered();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect filtered ingress", (Object)FP1, (Object)intent.filteredIngressPoint());
        Assert.assertEquals((String)"incorrect filtered egress", (Object)FPS2, (Object)intent.filteredEgressPoints());
    }

    private Set<FilteredConnectPoint> filterPoints(Set<ConnectPoint> points) {
        HashSet<FilteredConnectPoint> result = new HashSet<FilteredConnectPoint>();
        points.iterator().forEachRemaining(point -> result.add(new FilteredConnectPoint(point)));
        return result;
    }

    protected SinglePointToMultiPointIntent createOne() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(new FilteredConnectPoint(P1)).filteredEgressPoints(this.filterPoints(PS2)).build();
    }

    protected SinglePointToMultiPointIntent createAnother() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(new FilteredConnectPoint(P2)).filteredEgressPoints(this.filterPoints(PS1)).build();
    }

    protected SinglePointToMultiPointIntent createWithResourceGroup() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(new FilteredConnectPoint(P2)).filteredEgressPoints(this.filterPoints(PS1)).resourceGroup(RESOURCE_GROUP).build();
    }

    protected SinglePointToMultiPointIntent createFilteredOne() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).treatment(NOP).filteredEgressPoints(FPS1).filteredIngressPoint(FP2).build();
    }

    protected SinglePointToMultiPointIntent createAnotherFiltered() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).treatment(NOP).filteredEgressPoints(FPS2).filteredIngressPoint(FP1).build();
    }

    protected SinglePointToMultiPointIntent createWrongIntent() {
        return SinglePointToMultiPointIntent.builder().appId(APPID).treatment(NOP).selector(VLANMATCH1).filteredEgressPoints(FPS2).filteredIngressPoint(FP1).build();
    }
}

