/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.chart;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.ui.chart.ChartModel;
import org.onosproject.ui.chart.ChartUtils;

public class ChartUtilsTest {
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String ARRAY_AS_STRING = "[{\"foo\":\"1.0\",\"bar\":\"2.0\"},{\"foo\":\"3.0\",\"bar\":\"4.0\"}]";
    private static final String NODE_AS_STRING = "{\"dev1\":\"of:0000000000000001\",\"dev2\":\"of:0000000000000002\"}";

    @Test
    public void basic() {
        ChartModel cm = new ChartModel(new String[]{FOO, BAR});
        cm.addDataPoint((Object)1L).data(FOO, (Object)1.0).data(BAR, (Object)2.0);
        cm.addDataPoint((Object)2L).data(FOO, (Object)3.0).data(BAR, (Object)4.0);
        ArrayNode array = ChartUtils.generateDataPointArrayNode((ChartModel)cm);
        Assert.assertEquals((String)"wrong results", (Object)ARRAY_AS_STRING, (Object)array.toString());
    }

    @Test
    public void annot() {
        ChartModel cm = new ChartModel(new String[]{FOO, BAR});
        cm.addAnnotation("dev1", (Object)"of:0000000000000001");
        cm.addAnnotation("dev2", (Object)"of:0000000000000002");
        ObjectNode node = ChartUtils.generateAnnotObjectNode((ChartModel)cm);
        Assert.assertEquals((String)"wrong results", (Object)NODE_AS_STRING, (Object)node.toString());
    }
}

