/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cfg;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.cfg.ConfigProperty;

public class ConfigPropertyTest {
    @Test
    public void basics() {
        ConfigProperty p = ConfigProperty.defineProperty((String)"foo", (ConfigProperty.Type)ConfigProperty.Type.STRING, (String)"bar", (String)"Foo Prop");
        this.validate(p, "foo", ConfigProperty.Type.STRING, "bar", "bar");
        p = ConfigProperty.setProperty((ConfigProperty)p, (String)"BAR");
        this.validate(p, "foo", ConfigProperty.Type.STRING, "BAR", "bar");
        p = ConfigProperty.resetProperty((ConfigProperty)p);
        this.validate(p, "foo", ConfigProperty.Type.STRING, "bar", "bar");
    }

    @Test
    public void equality() {
        new EqualsTester().addEqualityGroup(new Object[]{ConfigProperty.defineProperty((String)"foo", (ConfigProperty.Type)ConfigProperty.Type.STRING, (String)"bar", (String)"Desc"), ConfigProperty.defineProperty((String)"foo", (ConfigProperty.Type)ConfigProperty.Type.STRING, (String)"goo", (String)"Desc")}).addEqualityGroup(new Object[]{ConfigProperty.defineProperty((String)"bar", (ConfigProperty.Type)ConfigProperty.Type.STRING, (String)"bar", (String)"Desc"), ConfigProperty.defineProperty((String)"bar", (ConfigProperty.Type)ConfigProperty.Type.STRING, (String)"goo", (String)"Desc")}).testEquals();
    }

    private void validate(ConfigProperty p, String name, ConfigProperty.Type type, String v, String dv) {
        Assert.assertEquals((String)"incorrect name", (Object)name, (Object)p.name());
        Assert.assertEquals((String)"incorrect type", (Object)type, (Object)p.type());
        Assert.assertEquals((String)"incorrect value", (Object)v, (Object)p.value());
        Assert.assertEquals((String)"incorrect default", (Object)dv, (Object)p.defaultValue());
        Assert.assertEquals((String)"incorrect description", (Object)"Foo Prop", (Object)p.description());
    }

    @Test
    public void asInteger() {
        ConfigProperty p = ConfigProperty.defineProperty((String)"foo", (ConfigProperty.Type)ConfigProperty.Type.INTEGER, (String)"123", (String)"Foo Prop");
        this.validate(p, "foo", ConfigProperty.Type.INTEGER, "123", "123");
        Assert.assertEquals((String)"incorrect value", (long)123L, (long)p.asInteger());
        Assert.assertEquals((String)"incorrect value", (long)123L, (long)p.asLong());
    }

    @Test
    public void asLong() {
        ConfigProperty p = ConfigProperty.defineProperty((String)"foo", (ConfigProperty.Type)ConfigProperty.Type.LONG, (String)"123", (String)"Foo Prop");
        this.validate(p, "foo", ConfigProperty.Type.LONG, "123", "123");
        Assert.assertEquals((String)"incorrect value", (long)123L, (long)p.asLong());
    }

    @Test
    public void asFloat() {
        ConfigProperty p = ConfigProperty.defineProperty((String)"foo", (ConfigProperty.Type)ConfigProperty.Type.FLOAT, (String)"123.0", (String)"Foo Prop");
        this.validate(p, "foo", ConfigProperty.Type.FLOAT, "123.0", "123.0");
        Assert.assertEquals((String)"incorrect value", (double)123.0, (double)p.asFloat(), (double)0.01);
        Assert.assertEquals((String)"incorrect value", (double)123.0, (double)p.asDouble(), (double)0.01);
    }

    @Test
    public void asDouble() {
        ConfigProperty p = ConfigProperty.defineProperty((String)"foo", (ConfigProperty.Type)ConfigProperty.Type.DOUBLE, (String)"123.0", (String)"Foo Prop");
        this.validate(p, "foo", ConfigProperty.Type.DOUBLE, "123.0", "123.0");
        Assert.assertEquals((String)"incorrect value", (double)123.0, (double)p.asDouble(), (double)0.01);
    }

    @Test
    public void asBoolean() {
        ConfigProperty p = ConfigProperty.defineProperty((String)"foo", (ConfigProperty.Type)ConfigProperty.Type.BOOLEAN, (String)"true", (String)"Foo Prop");
        this.validate(p, "foo", ConfigProperty.Type.BOOLEAN, "true", "true");
        Assert.assertEquals((String)"incorrect value", (Object)true, (Object)p.asBoolean());
    }
}

