/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.onosproject.core.GroupId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DataPlaneEntity;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.group.Group;

public class PipelineTraceableInput {
    TrafficSelector ingressPacket;
    ConnectPoint ingressPort;
    List<FlowEntry> flows = Lists.newArrayList();
    Map<GroupId, Group> groups = Maps.newHashMap();

    public PipelineTraceableInput(TrafficSelector ingressPacket, ConnectPoint ingressPort, List<DataPlaneEntity> deviceState) {
        this.ingressPacket = ingressPacket;
        this.ingressPort = ingressPort;
        this.processDeviceState(deviceState);
    }

    private void processDeviceState(List<DataPlaneEntity> deviceState) {
        deviceState.forEach(entity -> {
            if (entity.getType() == DataPlaneEntity.Type.FLOWRULE) {
                this.flows.add(entity.getFlowEntry());
            } else if (entity.getType() == DataPlaneEntity.Type.GROUP) {
                this.groups.put(entity.getGroupEntry().id(), entity.getGroupEntry());
            }
        });
    }

    public TrafficSelector ingressPacket() {
        return this.ingressPacket;
    }

    public ConnectPoint ingressPort() {
        return this.ingressPort;
    }

    public List<FlowEntry> flows() {
        return this.flows;
    }

    public Map<GroupId, Group> groups() {
        return this.groups;
    }

    public Group getGroup(GroupId groupId) {
        return this.groups.get((Object)groupId);
    }
}

