/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.constraint.MarkerConstraint;

public final class NonDisruptiveConstraint
extends MarkerConstraint {
    private static final NonDisruptiveConstraint NON_DISRUPTIVE_CONSTRAINT = new NonDisruptiveConstraint();

    protected NonDisruptiveConstraint() {
    }

    public static boolean requireNonDisruptive(Intent intent) {
        if (intent instanceof ConnectivityIntent) {
            ConnectivityIntent connectivityIntent = (ConnectivityIntent)intent;
            return connectivityIntent.constraints().stream().anyMatch(p -> p instanceof NonDisruptiveConstraint);
        }
        return false;
    }

    public static NonDisruptiveConstraint nonDisruptive() {
        return NON_DISRUPTIVE_CONSTRAINT;
    }

    @Override
    public String toString() {
        return "Non-disruptive reallocation required";
    }
}

