/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.BandEntry;

public final class DefaultBand
implements Band,
BandEntry {
    private final Band.Type type;
    private final long rate;
    private final Long burstSize;
    private final Short prec;
    private long packets;
    private long bytes;

    public DefaultBand(Band.Type type, long rate, Long burstSize, Short prec) {
        this.type = type;
        if (type == Band.Type.REMARK) {
            Preconditions.checkArgument((prec <= 255 && prec >= 0 ? 1 : 0) != 0, (Object)"Precedence out of range");
        }
        this.rate = rate;
        this.burstSize = burstSize;
        this.prec = prec;
    }

    @Override
    public long rate() {
        return this.rate;
    }

    @Override
    public Long burst() {
        return this.burstSize;
    }

    @Override
    public Short dropPrecedence() {
        return this.prec;
    }

    @Override
    public Band.Type type() {
        return this.type;
    }

    @Override
    public long packets() {
        return this.packets;
    }

    @Override
    public long bytes() {
        return this.bytes;
    }

    @Override
    public void setPackets(long packets) {
        this.packets = packets;
    }

    @Override
    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rate", this.rate).add("burst-size", (Object)this.burstSize).add("type", (Object)this.type).add("drop-precedence", (Object)this.prec).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements Band.Builder {
        private long rate;
        private Long burstSize;
        private Short prec;
        private Band.Type type;

        @Override
        public Band.Builder withRate(long rate) {
            this.rate = rate;
            return this;
        }

        @Override
        public Band.Builder burstSize(long burstSize) {
            this.burstSize = burstSize;
            return this;
        }

        @Override
        public Band.Builder dropPrecedence(short prec) {
            this.prec = prec;
            return this;
        }

        @Override
        public Band.Builder ofType(Band.Type type) {
            this.type = type;
            return this;
        }

        @Override
        public DefaultBand build() {
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Band type can not be null");
            Preconditions.checkArgument((boolean)(this.type == Band.Type.REMARK ^ this.prec == null), (Object)"Only REMARK bands can have a precedence.");
            return new DefaultBand(this.type, this.rate, this.burstSize, this.prec);
        }
    }
}

