/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiFieldMatch;

@Beta
public final class PiRangeFieldMatch
extends PiFieldMatch {
    private final ImmutableByteSequence lowValue;
    private final ImmutableByteSequence highValue;

    public PiRangeFieldMatch(PiMatchFieldId fieldId, ImmutableByteSequence lowValue, ImmutableByteSequence highValue) {
        super(fieldId);
        this.lowValue = (ImmutableByteSequence)Preconditions.checkNotNull((Object)lowValue);
        this.highValue = (ImmutableByteSequence)Preconditions.checkNotNull((Object)highValue);
        Preconditions.checkArgument((lowValue.size() == highValue.size() && lowValue.size() > 0 ? 1 : 0) != 0, (Object)"Low and high values must have the same non-zero size.");
    }

    @Override
    public PiMatchType type() {
        return PiMatchType.RANGE;
    }

    public ImmutableByteSequence lowValue() {
        return this.lowValue;
    }

    public ImmutableByteSequence highValue() {
        return this.highValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiRangeFieldMatch that = (PiRangeFieldMatch)o;
        return Objects.equal((Object)((Object)this.fieldId()), (Object)((Object)that.fieldId())) && Objects.equal((Object)this.lowValue, (Object)that.lowValue) && Objects.equal((Object)this.highValue, (Object)that.highValue);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldId(), this.lowValue, this.highValue});
    }

    public String toString() {
        return this.fieldId().toString() + "=" + this.lowValue.toString() + "--" + this.highValue.toString();
    }
}

