/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onosproject.net.behaviour.trafficcontrol.DefaultTokenBucket;
import org.onosproject.net.behaviour.trafficcontrol.TokenBucket;

public class TokenBucketTest {
    private static final long RATE = 1L;
    private static final short DSCP_PREC = 2;
    private static final short DSCP_CL = 250;
    private static final short WRONG_DSCP = -1;
    @Rule
    public ExpectedException exceptionNullAction = ExpectedException.none();
    @Rule
    public ExpectedException exceptionWrongDscp = ExpectedException.none();

    @Test
    public void testDropCreation() {
        TokenBucket drop = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DROP).withType(TokenBucket.Type.COMMITTED).build();
        Assert.assertThat((Object)drop, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)drop.rate(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)drop.burstSize(), (Matcher)Matchers.is((Object)3000L));
        Assert.assertThat((Object)drop.action(), (Matcher)Matchers.is((Object)TokenBucket.Action.DROP));
        Assert.assertThat((Object)drop.type(), (Matcher)Matchers.is((Object)TokenBucket.Type.COMMITTED));
    }

    @Test
    public void testDscpPrecCreation() {
        TokenBucket mark = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_PRECEDENCE).withBurstSize(9000L).withDscp((short)2).withType(TokenBucket.Type.EXCESS).build();
        Assert.assertThat((Object)mark, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)mark.rate(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)mark.burstSize(), (Matcher)Matchers.is((Object)9000L));
        Assert.assertThat((Object)mark.action(), (Matcher)Matchers.is((Object)TokenBucket.Action.DSCP_PRECEDENCE));
        Assert.assertThat((Object)mark.dscp(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)mark.type(), (Matcher)Matchers.is((Object)TokenBucket.Type.EXCESS));
    }

    @Test
    public void testDscpClassCreation() {
        TokenBucket mark = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_CLASS).withDscp((short)250).withType(TokenBucket.Type.PEAK).build();
        Assert.assertThat((Object)mark, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)mark.rate(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)mark.burstSize(), (Matcher)Matchers.is((Object)3000L));
        Assert.assertThat((Object)mark.action(), (Matcher)Matchers.is((Object)TokenBucket.Action.DSCP_CLASS));
        Assert.assertThat((Object)mark.dscp(), (Matcher)Matchers.is((Object)250));
        Assert.assertThat((Object)mark.type(), (Matcher)Matchers.is((Object)TokenBucket.Type.PEAK));
    }

    @Test
    public void testNullActionCreation() {
        this.exceptionNullAction.expect(NullPointerException.class);
        DefaultTokenBucket.builder().withRate(1L).build();
    }

    @Test
    public void testWrongDscpCreation() {
        this.exceptionWrongDscp.expect(IllegalArgumentException.class);
        DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_PRECEDENCE).withDscp((short)-1).withType(TokenBucket.Type.COMMITTED).build();
    }

    @Test
    public void testEqualilty() {
        TokenBucket drop = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DROP).withType(TokenBucket.Type.COMMITTED).build();
        TokenBucket mark = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_PRECEDENCE).withDscp((short)2).withType(TokenBucket.Type.COMMITTED).build();
        TokenBucket copyDrop = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DROP).withType(TokenBucket.Type.COMMITTED).build();
        Assert.assertEquals((Object)drop, (Object)copyDrop);
        Assert.assertNotEquals((Object)mark, (Object)drop);
        Assert.assertNotEquals((Object)mark, (Object)copyDrop);
    }
}

