/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.annotations.Beta;
import java.util.concurrent.CompletableFuture;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.device.DeviceAgentListener;
import org.onosproject.net.driver.DeviceConnect;
import org.onosproject.net.provider.ProviderId;

@Beta
public interface DeviceHandshaker
extends DeviceConnect {
    public boolean isReachable();

    public CompletableFuture<Boolean> probeReachability();

    public boolean isAvailable();

    public CompletableFuture<Boolean> probeAvailability();

    public void roleChanged(MastershipRole var1);

    default public void roleChanged(int preference, long term) {
        if (preference == 0) {
            this.roleChanged(MastershipRole.MASTER);
        } else {
            this.roleChanged(MastershipRole.STANDBY);
        }
    }

    public MastershipRole getRole();

    default public void addDeviceAgentListener(ProviderId providerId, DeviceAgentListener listener) {
        throw new UnsupportedOperationException("Device agent listener registration not supported");
    }

    default public void removeDeviceAgentListener(ProviderId providerId) {
        throw new UnsupportedOperationException("Device agent listener removal not supported");
    }
}

