/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import org.onlab.packet.EthType;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.criteria.ArpHaCriterion;
import org.onosproject.net.flow.criteria.ArpOpCriterion;
import org.onosproject.net.flow.criteria.ArpPaCriterion;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.ExtensionCriterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPDscpCriterion;
import org.onosproject.net.flow.criteria.IPEcnCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.IPv6ExthdrFlagsCriterion;
import org.onosproject.net.flow.criteria.IPv6FlowLabelCriterion;
import org.onosproject.net.flow.criteria.IPv6NDLinkLayerAddressCriterion;
import org.onosproject.net.flow.criteria.IPv6NDTargetAddressCriterion;
import org.onosproject.net.flow.criteria.IcmpCodeCriterion;
import org.onosproject.net.flow.criteria.IcmpTypeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6CodeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6TypeCriterion;
import org.onosproject.net.flow.criteria.MetadataCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.MplsTcCriterion;
import org.onosproject.net.flow.criteria.OchSignalCriterion;
import org.onosproject.net.flow.criteria.OchSignalTypeCriterion;
import org.onosproject.net.flow.criteria.OduSignalIdCriterion;
import org.onosproject.net.flow.criteria.OduSignalTypeCriterion;
import org.onosproject.net.flow.criteria.PbbIsidCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.SctpPortCriterion;
import org.onosproject.net.flow.criteria.TcpFlagsCriterion;
import org.onosproject.net.flow.criteria.TcpPortCriterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.UdpPortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.criteria.VlanPcpCriterion;

public final class Criteria {
    private Criteria() {
    }

    public static Criterion matchInPort(PortNumber port) {
        return new PortCriterion(port, Criterion.Type.IN_PORT);
    }

    public static Criterion matchInPhyPort(PortNumber port) {
        return new PortCriterion(port, Criterion.Type.IN_PHY_PORT);
    }

    public static Criterion matchMetadata(long metadata) {
        return new MetadataCriterion(metadata);
    }

    public static Criterion matchEthDst(MacAddress mac) {
        return new EthCriterion(mac, Criterion.Type.ETH_DST);
    }

    public static Criterion matchEthDstMasked(MacAddress mac, MacAddress mask) {
        return new EthCriterion(mac, mask, Criterion.Type.ETH_DST_MASKED);
    }

    public static Criterion matchEthSrc(MacAddress mac) {
        return new EthCriterion(mac, Criterion.Type.ETH_SRC);
    }

    public static Criterion matchEthSrcMasked(MacAddress mac, MacAddress mask) {
        return new EthCriterion(mac, mask, Criterion.Type.ETH_SRC_MASKED);
    }

    public static Criterion matchEthType(int ethType) {
        return new EthTypeCriterion(ethType);
    }

    public static Criterion matchEthType(EthType ethType) {
        return new EthTypeCriterion(ethType);
    }

    public static Criterion matchVlanId(VlanId vlanId) {
        return new VlanIdCriterion(vlanId);
    }

    public static Criterion matchInnerVlanId(VlanId vlanId) {
        return new VlanIdCriterion(vlanId, Criterion.Type.INNER_VLAN_VID);
    }

    public static Criterion matchVlanPcp(byte vlanPcp) {
        return new VlanPcpCriterion(vlanPcp);
    }

    public static Criterion matchInnerVlanPcp(byte vlanPcp) {
        return new VlanPcpCriterion(vlanPcp, Criterion.Type.INNER_VLAN_PCP);
    }

    public static Criterion matchIPDscp(byte ipDscp) {
        return new IPDscpCriterion(ipDscp);
    }

    public static Criterion matchIPEcn(byte ipEcn) {
        return new IPEcnCriterion(ipEcn);
    }

    public static Criterion matchIPProtocol(short proto) {
        return new IPProtocolCriterion(proto);
    }

    public static Criterion matchIPSrc(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV4_SRC);
    }

    public static Criterion matchIPDst(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV4_DST);
    }

    public static Criterion matchTcpSrc(TpPort tcpPort) {
        return new TcpPortCriterion(tcpPort, Criterion.Type.TCP_SRC);
    }

    public static Criterion matchTcpSrcMasked(TpPort tcpPort, TpPort mask) {
        return new TcpPortCriterion(tcpPort, mask, Criterion.Type.TCP_SRC_MASKED);
    }

    public static Criterion matchTcpDst(TpPort tcpPort) {
        return new TcpPortCriterion(tcpPort, Criterion.Type.TCP_DST);
    }

    public static Criterion matchTcpDstMasked(TpPort tcpPort, TpPort mask) {
        return new TcpPortCriterion(tcpPort, mask, Criterion.Type.TCP_DST_MASKED);
    }

    public static Criterion matchTcpFlags(int flags) {
        return new TcpFlagsCriterion(flags);
    }

    public static Criterion matchUdpSrc(TpPort udpPort) {
        return new UdpPortCriterion(udpPort, Criterion.Type.UDP_SRC);
    }

    public static Criterion matchUdpSrcMasked(TpPort udpPort, TpPort mask) {
        return new UdpPortCriterion(udpPort, mask, Criterion.Type.UDP_SRC_MASKED);
    }

    public static Criterion matchUdpDst(TpPort udpPort) {
        return new UdpPortCriterion(udpPort, Criterion.Type.UDP_DST);
    }

    public static Criterion matchUdpDstMasked(TpPort udpPort, TpPort mask) {
        return new UdpPortCriterion(udpPort, mask, Criterion.Type.UDP_DST_MASKED);
    }

    public static Criterion matchSctpSrc(TpPort sctpPort) {
        return new SctpPortCriterion(sctpPort, Criterion.Type.SCTP_SRC);
    }

    public static Criterion matchSctpSrcMasked(TpPort sctpPort, TpPort mask) {
        return new SctpPortCriterion(sctpPort, mask, Criterion.Type.SCTP_SRC_MASKED);
    }

    public static Criterion matchSctpDst(TpPort sctpPort) {
        return new SctpPortCriterion(sctpPort, Criterion.Type.SCTP_DST);
    }

    public static Criterion matchSctpDstMasked(TpPort sctpPort, TpPort mask) {
        return new SctpPortCriterion(sctpPort, mask, Criterion.Type.SCTP_DST_MASKED);
    }

    public static Criterion matchIcmpType(short icmpType) {
        return new IcmpTypeCriterion(icmpType);
    }

    public static Criterion matchIcmpCode(short icmpCode) {
        return new IcmpCodeCriterion(icmpCode);
    }

    public static Criterion matchIPv6Src(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV6_SRC);
    }

    public static Criterion matchIPv6Dst(IpPrefix ip) {
        return new IPCriterion(ip, Criterion.Type.IPV6_DST);
    }

    public static Criterion matchIPv6FlowLabel(int flowLabel) {
        return new IPv6FlowLabelCriterion(flowLabel);
    }

    public static Criterion matchIcmpv6Type(short icmpv6Type) {
        return new Icmpv6TypeCriterion(icmpv6Type);
    }

    public static Criterion matchIcmpv6Code(short icmpv6Code) {
        return new Icmpv6CodeCriterion(icmpv6Code);
    }

    public static Criterion matchIPv6NDTargetAddress(Ip6Address targetAddress) {
        return new IPv6NDTargetAddressCriterion(targetAddress);
    }

    public static Criterion matchIPv6NDSourceLinkLayerAddress(MacAddress mac) {
        return new IPv6NDLinkLayerAddressCriterion(mac, Criterion.Type.IPV6_ND_SLL);
    }

    public static Criterion matchIPv6NDTargetLinkLayerAddress(MacAddress mac) {
        return new IPv6NDLinkLayerAddressCriterion(mac, Criterion.Type.IPV6_ND_TLL);
    }

    public static Criterion matchMplsLabel(MplsLabel mplsLabel) {
        return new MplsCriterion(mplsLabel);
    }

    public static Criterion matchMplsBos(boolean mplsBos) {
        return new MplsBosCriterion(mplsBos);
    }

    public static Criterion matchMplsTc(byte mplsTc) {
        return new MplsTcCriterion(mplsTc);
    }

    public static Criterion matchTunnelId(long tunnelId) {
        return new TunnelIdCriterion(tunnelId);
    }

    public static Criterion matchIPv6ExthdrFlags(int exthdrFlags) {
        return new IPv6ExthdrFlagsCriterion(exthdrFlags);
    }

    public static Criterion matchLambda(Lambda lambda) {
        if (lambda instanceof OchSignal) {
            return new OchSignalCriterion((OchSignal)lambda);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of Lambda: %s", lambda));
    }

    public static Criterion matchOchSignalType(OchSignalType signalType) {
        return new OchSignalTypeCriterion(signalType);
    }

    public static Criterion matchOduSignalId(OduSignalId oduSignalId) {
        return new OduSignalIdCriterion(oduSignalId);
    }

    public static Criterion matchOduSignalType(OduSignalType signalType) {
        return new OduSignalTypeCriterion(signalType);
    }

    public static Criterion matchArpTpa(Ip4Address ip) {
        return new ArpPaCriterion(ip, Criterion.Type.ARP_TPA);
    }

    public static Criterion matchArpSpa(Ip4Address ip) {
        return new ArpPaCriterion(ip, Criterion.Type.ARP_SPA);
    }

    public static Criterion matchArpTha(MacAddress mac) {
        return new ArpHaCriterion(mac, Criterion.Type.ARP_THA);
    }

    public static Criterion matchArpSha(MacAddress mac) {
        return new ArpHaCriterion(mac, Criterion.Type.ARP_SHA);
    }

    public static Criterion matchArpOp(int arpOp) {
        return new ArpOpCriterion(arpOp, Criterion.Type.ARP_OP);
    }

    public static Criterion matchPbbIsid(int pbbIsid) {
        return new PbbIsidCriterion(pbbIsid);
    }

    public static ExtensionCriterion extension(ExtensionSelector extensionSelector, DeviceId deviceId) {
        return new ExtensionCriterion(extensionSelector, deviceId);
    }

    public static Criterion dummy() {
        return new DummyCriterion();
    }

    private static class DummyCriterion
    implements Criterion {
        private DummyCriterion() {
        }

        @Override
        public Criterion.Type type() {
            return Criterion.Type.DUMMY;
        }
    }
}

