/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.OptionalInt;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiTableId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.runtime.PiMatchKey;
import org.onosproject.net.pi.runtime.PiTableEntry;

@Beta
public final class PiTableEntryHandle
extends PiHandle {
    private static final int NO_PRIORITY = -1;
    private final PiTableId tableId;
    private final PiMatchKey matchKey;
    private final int priority;

    private PiTableEntryHandle(DeviceId deviceId, PiTableId tableId, PiMatchKey matchKey, Integer priority) {
        super(deviceId);
        this.tableId = tableId;
        this.matchKey = matchKey;
        this.priority = priority;
    }

    public static PiTableEntryHandle of(DeviceId deviceId, PiTableEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        return new PiTableEntryHandle(deviceId, entry.table(), entry.matchKey(), entry.priority().orElse(-1));
    }

    public PiTableId tableId() {
        return this.tableId;
    }

    public PiMatchKey matchKey() {
        return this.matchKey;
    }

    public OptionalInt priority() {
        return this.priority == -1 ? OptionalInt.empty() : OptionalInt.of(this.priority);
    }

    @Override
    public PiEntityType entityType() {
        return PiEntityType.TABLE_ENTRY;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.tableId, this.matchKey, this.priority().orElse(-1)});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiTableEntryHandle other = (PiTableEntryHandle)obj;
        return Objects.equal((Object)this.deviceId(), (Object)other.deviceId()) && Objects.equal((Object)this.tableId, (Object)other.tableId) && Objects.equal((Object)this.matchKey, (Object)other.matchKey) && Objects.equal((Object)this.priority(), (Object)other.priority());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("tableId", (Object)this.tableId).add("matchKey", (Object)this.matchKey).add("priority", this.priority == -1 ? "N/A" : Integer.valueOf(this.priority)).toString();
    }
}

