/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.core.GroupId;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupOperation;

public class GroupOperationTest {
    private final GroupId groupId = new GroupId(6);
    private final TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
    private final GroupBucket bucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)this.treatment);
    private final GroupBuckets groupBuckets = new GroupBuckets((List)ImmutableList.of((Object)this.bucket));
    private final GroupOperation op1 = GroupOperation.createAddGroupOperation((GroupId)this.groupId, (GroupDescription.Type)GroupDescription.Type.ALL, (GroupBuckets)this.groupBuckets);
    private final GroupOperation sameAsOp1 = GroupOperation.createAddGroupOperation((GroupId)this.groupId, (GroupDescription.Type)GroupDescription.Type.ALL, (GroupBuckets)this.groupBuckets);
    private final GroupOperation op2 = GroupOperation.createAddGroupOperation((GroupId)this.groupId, (GroupDescription.Type)GroupDescription.Type.INDIRECT, (GroupBuckets)this.groupBuckets);
    private final GroupOperation op3 = GroupOperation.createDeleteGroupOperation((GroupId)this.groupId, (GroupDescription.Type)GroupDescription.Type.INDIRECT);
    private final GroupOperation op4 = GroupOperation.createModifyGroupOperation((GroupId)this.groupId, (GroupDescription.Type)GroupDescription.Type.INDIRECT, (GroupBuckets)this.groupBuckets);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(GroupOperation.class);
    }

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.op1, this.sameAsOp1}).addEqualityGroup(new Object[]{this.op2}).addEqualityGroup(new Object[]{this.op3}).addEqualityGroup(new Object[]{this.op4}).testEquals();
    }

    @Test
    public void testAddGroupOperation() {
        MatcherAssert.assertThat((Object)this.op1.buckets(), (Matcher)CoreMatchers.is((Object)this.groupBuckets));
        MatcherAssert.assertThat((Object)this.op1.groupId(), (Matcher)CoreMatchers.is((Object)this.groupId));
        MatcherAssert.assertThat((Object)this.op1.groupType(), (Matcher)CoreMatchers.is((Object)GroupDescription.Type.ALL));
        MatcherAssert.assertThat((Object)this.op1.opType(), (Matcher)CoreMatchers.is((Object)GroupOperation.Type.ADD));
    }
}

