/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiActionParamId;
import org.onosproject.net.pi.runtime.PiActionParam;

public class PiActionParamTest {
    private ImmutableByteSequence value1 = ImmutableByteSequence.copyFrom((int)0xA010101);
    private ImmutableByteSequence value2 = ImmutableByteSequence.copyFrom((int)167837954);
    private final PiActionParam piActionParam1 = new PiActionParam(PiActionParamId.of((String)"dstAddr"), this.value1);
    private final PiActionParam sameAsPiActionParam1 = new PiActionParam(PiActionParamId.of((String)"dstAddr"), this.value1);
    private final PiActionParam piActionParam2 = new PiActionParam(PiActionParamId.of((String)"dstAddr"), this.value2);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiActionParam.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piActionParam1, this.sameAsPiActionParam1}).addEqualityGroup(new Object[]{this.piActionParam2}).testEquals();
    }

    @Test
    public void testConstruction() {
        ImmutableByteSequence value = ImmutableByteSequence.copyFrom((int)184615170);
        PiActionParamId piActionParamId = PiActionParamId.of((String)"srcAddr");
        PiActionParam piActionParam = new PiActionParam(piActionParamId, value);
        MatcherAssert.assertThat((Object)piActionParam, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piActionParam.id(), (Matcher)Matchers.is((Object)piActionParamId));
        MatcherAssert.assertThat((Object)piActionParam.value(), (Matcher)Matchers.is((Object)value));
    }
}

