/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.basics.BasicElementConfig;

public final class BasicHostConfig
extends BasicElementConfig<HostId> {
    private static final String IPS = "ips";
    private static final String LOCATIONS = "locations";
    private static final String AUX_LOCATIONS = "auxLocations";
    private static final String INNER_VLAN = "innerVlan";
    private static final String OUTER_TPID = "outerTpid";
    private static final String DASH = "-";

    @Override
    public boolean isValid() {
        if (!this.isIntegralNumber(this.object, INNER_VLAN, Config.FieldPresence.OPTIONAL, 0L, 4095L)) {
            return false;
        }
        Preconditions.checkArgument((!this.hasField(this.object, OUTER_TPID) || (short)(Integer.decode(this.get(OUTER_TPID, "0")) & 0xFFFF) == EthType.EtherType.QINQ.ethType().toShort() || (short)(Integer.decode(this.get(OUTER_TPID, "0")) & 0xFFFF) == EthType.EtherType.VLAN.ethType().toShort() ? 1 : 0) != 0);
        this.locations();
        this.ipAddresses();
        this.auxLocations();
        return this.hasOnlyFields("allowed", "name", "locType", "latitude", "longitude", "roles", "gridX", "gridY", "uiType", "rackAddress", "owner", IPS, LOCATIONS, AUX_LOCATIONS, INNER_VLAN, OUTER_TPID);
    }

    @Override
    public String name() {
        return this.get("name", DASH);
    }

    public Set<HostLocation> locations() {
        if (!this.object.has(LOCATIONS)) {
            return null;
        }
        ImmutableSet.Builder locationsSetBuilder = ImmutableSet.builder();
        ArrayNode locationNodes = (ArrayNode)this.object.path(LOCATIONS);
        locationNodes.forEach(n -> {
            ConnectPoint cp = ConnectPoint.deviceConnectPoint(n.asText());
            locationsSetBuilder.add((Object)new HostLocation(cp, 0L));
        });
        ImmutableSet locations = locationsSetBuilder.build();
        if (locations.isEmpty()) {
            throw new IllegalArgumentException("Host should have at least one location");
        }
        return locations;
    }

    public Set<HostLocation> auxLocations() {
        if (!this.object.has(AUX_LOCATIONS)) {
            return null;
        }
        ImmutableSet.Builder auxLocationsSetBuilder = ImmutableSet.builder();
        ArrayNode auxLocationNodes = (ArrayNode)this.object.path(AUX_LOCATIONS);
        auxLocationNodes.forEach(n -> {
            ConnectPoint cp = ConnectPoint.deviceConnectPoint(n.asText());
            auxLocationsSetBuilder.add((Object)new HostLocation(cp, 0L));
        });
        return auxLocationsSetBuilder.build();
    }

    public BasicHostConfig setLocations(Set<HostLocation> locations) {
        return (BasicHostConfig)this.setOrClear(LOCATIONS, locations);
    }

    public BasicHostConfig setAuxLocations(Set<HostLocation> auxLocations) {
        return (BasicHostConfig)this.setOrClear(AUX_LOCATIONS, auxLocations);
    }

    public Set<IpAddress> ipAddresses() {
        HashSet<IpAddress> ipAddresses = new HashSet<IpAddress>();
        if (this.object.has(IPS)) {
            ArrayNode ipNodes = (ArrayNode)this.object.path(IPS);
            ipNodes.forEach(n -> ipAddresses.add(IpAddress.valueOf((String)n.asText())));
            return ipAddresses;
        }
        return null;
    }

    public BasicHostConfig setIps(Set<IpAddress> ipAddresses) {
        return (BasicHostConfig)this.setOrClear(IPS, ipAddresses);
    }

    public VlanId innerVlan() {
        String vlan = this.get(INNER_VLAN, null);
        return vlan == null ? VlanId.NONE : VlanId.vlanId((short)Short.valueOf(vlan));
    }

    public BasicHostConfig setInnerVlan(VlanId vlanId) {
        return (BasicHostConfig)this.setOrClear(INNER_VLAN, vlanId.toString());
    }

    public EthType outerTpid() {
        short tpid = (short)(Integer.decode(this.get(OUTER_TPID, "0x8100")) & 0xFFFF);
        if (tpid != EthType.EtherType.VLAN.ethType().toShort() && tpid != EthType.EtherType.QINQ.ethType().toShort()) {
            return EthType.EtherType.UNKNOWN.ethType();
        }
        return EthType.EtherType.lookup((short)tpid).ethType();
    }

    public BasicHostConfig setOuterTpid(EthType tpid) {
        return (BasicHostConfig)this.setOrClear(OUTER_TPID, String.format("0x%04X", tpid.toShort()));
    }
}

