/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.Beta;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.VlanId;
import org.onosproject.TestApplicationId;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.basics.McastConfig;

@Beta
public class McastConfigTest {
    private static final TestApplicationId APP_ID = new TestApplicationId("org.onosproject.core");
    private McastConfig config;
    private McastConfig invalidConfig;
    private static final VlanId INGRESS_VLAN_1 = VlanId.NONE;
    private static final VlanId EGRESS_VLAN_1 = VlanId.NONE;
    private static final VlanId INGRESS_VLAN_2 = VlanId.vlanId((short)100);
    private static final VlanId EGRESS_VLAN_2 = VlanId.vlanId((short)100);

    @Before
    public void setUp() throws Exception {
        InputStream jsonStream = McastConfigTest.class.getResourceAsStream("/mcast-config.json");
        InputStream invalidJsonStream = McastConfigTest.class.getResourceAsStream("/mcast-config-invalid.json");
        TestApplicationId subject = APP_ID;
        String key = "org.onosproject.core";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(jsonStream);
        JsonNode invalidJsonNode = mapper.readTree(invalidJsonStream);
        MockDelegate delegate = new MockDelegate();
        this.config = new McastConfig();
        this.config.init((Object)subject, key, jsonNode, mapper, (ConfigApplyDelegate)delegate);
        this.invalidConfig = new McastConfig();
        this.invalidConfig.init((Object)subject, key, invalidJsonNode, mapper, (ConfigApplyDelegate)delegate);
    }

    @Test
    public void isValid() throws Exception {
        Assert.assertTrue((boolean)this.config.isValid());
        Assert.assertFalse((boolean)this.invalidConfig.isValid());
    }

    @Test
    public void ingressVlan() throws Exception {
        VlanId ingressVlan = this.config.ingressVlan();
        Assert.assertNotNull((String)"ingressVlan should not be null", (Object)ingressVlan);
        Assert.assertThat((Object)ingressVlan, (Matcher)Matchers.is((Object)INGRESS_VLAN_1));
    }

    @Test
    public void setIngressVlan() throws Exception {
        this.config.setIngressVlan(INGRESS_VLAN_2);
        VlanId ingressVlan = this.config.ingressVlan();
        Assert.assertNotNull((String)"ingressVlan should not be null", (Object)ingressVlan);
        Assert.assertThat((Object)ingressVlan, (Matcher)Matchers.is((Object)INGRESS_VLAN_2));
    }

    @Test
    public void egressVlan() throws Exception {
        VlanId egressVlan = this.config.egressVlan();
        Assert.assertNotNull((String)"egressVlan should not be null", (Object)egressVlan);
        Assert.assertThat((Object)egressVlan, (Matcher)Matchers.is((Object)EGRESS_VLAN_1));
    }

    @Test
    public void setEgressVlan() throws Exception {
        this.config.setEgressVlan(EGRESS_VLAN_2);
        VlanId egressVlan = this.config.egressVlan();
        Assert.assertNotNull((String)"egressVlan should not be null", (Object)egressVlan);
        Assert.assertThat((Object)egressVlan, (Matcher)Matchers.is((Object)EGRESS_VLAN_2));
    }

    private class MockDelegate
    implements ConfigApplyDelegate {
        private MockDelegate() {
        }

        public void onApply(Config config) {
        }
    }
}

