/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.lion;

import java.util.Locale;
import java.util.ResourceBundle;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onosproject.ui.AbstractUiTest;
import org.onosproject.ui.lion.LionUtils;

public class LionUtilsTest
extends AbstractUiTest {
    private static Locale systemLocale;
    private ResourceBundle res;
    private Locale locale;

    @BeforeClass
    public static void classSetup() {
        systemLocale = Locale.getDefault();
    }

    @AfterClass
    public static void classTeardown() {
        Locale.setDefault(systemLocale);
    }

    @Before
    public void testSetup() {
        Locale.setDefault(Locale.US);
    }

    @Test
    public void getBundleByClassAndName() {
        LionUtilsTest.title("getBundleByClassAndName");
        this.res = LionUtils.getBundledResource(LionUtilsTest.class, (String)"SomeResource");
        Assert.assertNotNull((String)"missing resource bundle", (Object)this.res);
        String v1 = this.res.getString("key1");
        String v2 = this.res.getString("key2");
        LionUtilsTest.print("v1 is %s, v2 is %s", v1, v2);
        Assert.assertEquals((String)"v1 value wrong", (Object)"value one", (Object)v1);
        Assert.assertEquals((String)"v2 value wrong", (Object)"value two", (Object)v2);
        this.res = LionUtils.getBundledResource(LionUtils.class, (String)"SomeOtherResource");
        Assert.assertNotNull((String)"missing OTHER resource bundle", (Object)this.res);
        v1 = this.res.getString("key1");
        v2 = this.res.getString("key2");
        LionUtilsTest.print("v1 is %s, v2 is %s", v1, v2);
        Assert.assertEquals((String)"v1 value wrong", (Object)"Hay", (Object)v1);
        Assert.assertEquals((String)"v2 value wrong", (Object)"Bee", (Object)v2);
    }

    @Test
    public void getBundleByClassname() {
        LionUtilsTest.title("getBundleByClassname");
        this.res = LionUtils.getBundledResource(LionUtils.class);
        Assert.assertNotNull((String)"missing resource bundle", (Object)this.res);
        String v1 = this.res.getString("foo");
        String v2 = this.res.getString("boo");
        LionUtilsTest.print("v1 is %s, v2 is %s", v1, v2);
        Assert.assertEquals((String)"v1 value wrong", (Object)"bar", (Object)v1);
        Assert.assertEquals((String)"v2 value wrong", (Object)"ghost", (Object)v2);
    }

    @Test
    public void getBundleByFqcn() {
        LionUtilsTest.title("getBundleByFqcn");
        String fqcn = "org.onosproject.ui.lion.LionUtils";
        this.res = LionUtils.getBundledResource((String)fqcn);
        Assert.assertNotNull((String)"missing resource bundle", (Object)this.res);
        String v1 = this.res.getString("foo");
        String v2 = this.res.getString("boo");
        LionUtilsTest.print("v1 is %s, v2 is %s", v1, v2);
        Assert.assertEquals((String)"v1 value wrong", (Object)"bar", (Object)v1);
        Assert.assertEquals((String)"v2 value wrong", (Object)"ghost", (Object)v2);
    }

    @Test
    public void runtimeLocale() {
        LionUtilsTest.title("runtimeLocale");
        Locale runtime = LionUtils.setupRuntimeLocale();
        LionUtilsTest.print("locale is [%s]", runtime);
    }

    @Test(expected=NullPointerException.class)
    public void localeFromStringNull() {
        LionUtils.localeFromString(null);
    }

    private void checkLanguageCountry(Locale locale, String expL, String expC) {
        Assert.assertEquals((String)("Wrong language: " + expL), (Object)expL, (Object)locale.getLanguage());
        Assert.assertEquals((String)("Wrong country: " + expC), (Object)expC, (Object)locale.getCountry());
    }

    @Test
    public void localeFromStringEmpty() {
        LionUtilsTest.title("localeFromStringEmpty");
        this.locale = LionUtils.localeFromString((String)"");
        this.checkLanguageCountry(this.locale, "", "");
    }

    @Test
    public void localeFromStringRu() {
        LionUtilsTest.title("localeFromStringRu");
        this.locale = LionUtils.localeFromString((String)"ru");
        this.checkLanguageCountry(this.locale, "ru", "");
    }

    @Test
    public void localeFromStringEnGB() {
        LionUtilsTest.title("localeFromStringEnGB");
        this.locale = LionUtils.localeFromString((String)"en_GB");
        this.checkLanguageCountry(this.locale, "en", "GB");
    }

    @Test
    public void localeFromStringItIT() {
        LionUtilsTest.title("localeFromStringItIT");
        this.locale = LionUtils.localeFromString((String)"it_IT");
        this.checkLanguageCountry(this.locale, "it", "IT");
    }

    @Test
    public void localeFromStringFrCA() {
        LionUtilsTest.title("localeFromStringFrCA");
        this.locale = LionUtils.localeFromString((String)"fr_CA");
        this.checkLanguageCountry(this.locale, "fr", "CA");
    }

    @Test
    public void localeFromStringKoKR() {
        LionUtilsTest.title("localeFromStringKoKR");
        this.locale = LionUtils.localeFromString((String)"ko_KR");
        this.checkLanguageCountry(this.locale, "ko", "KR");
    }

    private void checkLookups(String computer, String disk, String monitor, String keyboard) {
        this.res = LionUtils.getBundledResource(LionUtils.class, (String)"MyBundle");
        LionUtilsTest.print("res locale is %s", this.res.getLocale().getLanguage());
        LionUtilsTest.print("a keyboard in this language is '%s'", this.res.getString("keyboard"));
        Assert.assertEquals((String)"wrong computer", (Object)computer, (Object)this.res.getString("computer"));
        Assert.assertEquals((String)"wrong disk", (Object)disk, (Object)this.res.getString("disk"));
        Assert.assertEquals((String)"wrong monitor", (Object)monitor, (Object)this.res.getString("monitor"));
        Assert.assertEquals((String)"wrong keyboard", (Object)keyboard, (Object)this.res.getString("keyboard"));
    }

    @Test
    public void messagesInEnglish() {
        LionUtilsTest.title("messagesInEnglish");
        this.checkLookups("computer", "disk", "monitor", "keyboard");
    }

    @Test
    public void messagesInGerman() {
        LionUtilsTest.title("messagesInGerman");
        Locale.setDefault(Locale.GERMAN);
        this.checkLookups("Computer", "Platte", "Monitor", "Tastatur");
    }

    @Test
    public void messagesInItalian() {
        LionUtilsTest.title("messagesInItalian");
        Locale.setDefault(Locale.ITALIAN);
        this.checkLookups("Calcolatore", "Disco", "Schermo", "Tastiera");
    }

    @Test
    public void messagesInZhTw() {
        LionUtilsTest.title("messagesInZhTW");
        Locale.setDefault(Locale.TRADITIONAL_CHINESE);
        this.checkLookups("\u96fb\u8166", "\u78c1\u789f", "\u87a2\u5e55", "\u9375\u76e4");
    }

    @Test
    public void messagesInKorean() {
        LionUtilsTest.title("messagesInKorean");
        Locale.setDefault(Locale.KOREA);
        this.checkLookups("\ucef4\ud4e8\ud130", "\ub514\uc2a4\ud06c", "\ubaa8\ub2c8\ud130", "\ud0a4\ubcf4\ub4dc");
    }

    @Test
    public void messagesInZhCN() {
        LionUtilsTest.title("messagesInZhCN");
        Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
        this.checkLookups("\u7535\u8111", "\u78c1\u76d8", "\u5c4f\u5e55", "\u952e\u76d8");
    }
}

