/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.protection;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.behaviour.protection.TransportEndpointId;

@Beta
@Immutable
public class TransportEndpointState {
    private final TransportEndpointId id;
    private final boolean live;
    @Beta
    private final Map<String, String> attributes;
    private final TransportEndpointDescription description;

    protected TransportEndpointState(TransportEndpointDescription description, TransportEndpointId id, boolean live, Map<String, String> attributes) {
        this.id = (TransportEndpointId)((Object)Preconditions.checkNotNull((Object)((Object)id)));
        this.live = live;
        this.description = (TransportEndpointDescription)Preconditions.checkNotNull((Object)description);
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public TransportEndpointId id() {
        return this.id;
    }

    public boolean isLive() {
        return this.live;
    }

    public TransportEndpointDescription description() {
        return this.description;
    }

    @Beta
    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("live", this.live).add("description", (Object)this.description).add("attributes", this.attributes).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TransportEndpointId id;
        private boolean live;
        private Map<String, String> attributes = new HashMap<String, String>();
        private TransportEndpointDescription description;

        public Builder copyFrom(TransportEndpointState src) {
            this.id = src.id();
            this.live = src.isLive();
            this.attributes.putAll(src.attributes());
            this.description = src.description();
            return this;
        }

        public Builder withId(TransportEndpointId id) {
            this.id = (TransportEndpointId)((Object)Preconditions.checkNotNull((Object)((Object)id)));
            return this;
        }

        public Builder withLive(boolean live) {
            this.live = live;
            return this;
        }

        public Builder withDescription(TransportEndpointDescription description) {
            this.description = (TransportEndpointDescription)Preconditions.checkNotNull((Object)description);
            return this;
        }

        public Builder addAttributes(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder replaceAttributes(Map<String, String> attributes) {
            this.attributes.clear();
            return this.addAttributes(attributes);
        }

        public TransportEndpointState build() {
            Preconditions.checkNotNull((Object)((Object)this.id), (Object)"id field is mandatory");
            Preconditions.checkNotNull((Object)this.description, (Object)"description field is mandatory");
            return new TransportEndpointState(this.description, this.id, this.live, this.attributes);
        }
    }
}

