/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.onosproject.net.domain.DomainIntent;
import org.onosproject.net.domain.DomainIntentOperation;
import org.onosproject.net.domain.DomainIntentOperationsContext;
import org.onosproject.net.domain.NullDomainIntentOperationsContext;

public class DomainIntentOperations {
    private final List<DomainIntentOperation> stages;
    private final DomainIntentOperationsContext callback;

    private DomainIntentOperations(List<DomainIntentOperation> stages, DomainIntentOperationsContext cb) {
        this.stages = stages;
        this.callback = cb;
    }

    protected DomainIntentOperations() {
        this.stages = null;
        this.callback = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<DomainIntentOperation> stages() {
        return this.stages;
    }

    public DomainIntentOperationsContext callback() {
        return this.callback;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stages", this.stages).toString();
    }

    public static final class Builder {
        private final ImmutableList.Builder<DomainIntentOperation> listBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder add(DomainIntent intent) {
            this.listBuilder.add((Object)new DomainIntentOperation(intent, DomainIntentOperation.Type.ADD));
            return this;
        }

        public Builder operation(DomainIntentOperation domainIntentOperation) {
            this.listBuilder.add((Object)domainIntentOperation);
            return this;
        }

        public Builder remove(DomainIntent intent) {
            this.listBuilder.add((Object)new DomainIntentOperation(intent, DomainIntentOperation.Type.REMOVE));
            return this;
        }

        public DomainIntentOperations build() {
            return this.build(NullDomainIntentOperationsContext.getInstance());
        }

        public DomainIntentOperations build(DomainIntentOperationsContext cb) {
            Preconditions.checkNotNull((Object)cb);
            return new DomainIntentOperations((List<DomainIntentOperation>)this.listBuilder.build(), cb);
        }
    }
}

