/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.primitives.DefaultDistributedLock;
import org.onosproject.store.service.DistributedLock;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Version;

public interface AsyncDistributedLock
extends DistributedPrimitive {
    @Override
    default public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.LOCK;
    }

    public CompletableFuture<Version> lock();

    public CompletableFuture<Optional<Version>> tryLock();

    public CompletableFuture<Optional<Version>> tryLock(Duration var1);

    public CompletableFuture<Void> unlock();

    default public DistributedLock asLock() {
        return this.asLock(-1L);
    }

    default public DistributedLock asLock(long timeoutMillis) {
        return new DefaultDistributedLock(this, timeoutMillis);
    }
}

