/*
 * Copyright 2015-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.rest;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

/**
 * Self-registering REST API provider.
 */
public abstract class AbstractApiDocRegistrator {

    protected final ApiDocProvider provider;

    @Reference(cardinality = ReferenceCardinality.MANDATORY)
    protected ApiDocService service;

    /**
     * Creates registrator for the specified REST API doc provider.
     *
     * @param provider REST API provider
     */
    protected AbstractApiDocRegistrator(ApiDocProvider provider) {
        this.provider = provider;
    }

    @Activate
    protected void activate() {
        service.register(provider);
    }

    @Deactivate
    protected void deactivate() {
        service.unregister(provider);
    }
}
