/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.app;

import java.util.Optional;
import org.junit.Test;
import org.onosproject.app.ApplicationEvent;
import org.onosproject.app.DefaultApplicationDescriptionTest;
import org.onosproject.core.Application;
import org.onosproject.core.DefaultApplication;
import org.onosproject.core.DefaultApplicationTest;
import org.onosproject.event.AbstractEventTest;

public class ApplicationEventTest
extends AbstractEventTest {
    private Application createApp() {
        return DefaultApplication.builder().withAppId(DefaultApplicationTest.APP_ID).withVersion(DefaultApplicationDescriptionTest.VER).withTitle("Awesome App").withDescription("Awesome application from Circus, Inc.").withOrigin("Circus").withCategory("other").withUrl("http://www.onosproject.org").withReadme("Awesome application from Circus, Inc.").withIcon(DefaultApplicationDescriptionTest.ICON).withRole(DefaultApplicationDescriptionTest.ROLE).withPermissions(DefaultApplicationDescriptionTest.PERMS).withFeaturesRepo(Optional.of(DefaultApplicationDescriptionTest.FURL)).withFeatures(DefaultApplicationDescriptionTest.FEATURES).withRequiredApps(DefaultApplicationDescriptionTest.APPS).build();
    }

    @Override
    @Test
    public void withoutTime() {
        Application app = this.createApp();
        ApplicationEvent event = new ApplicationEvent(ApplicationEvent.Type.APP_ACTIVATED, app, 123L);
        ApplicationEventTest.validateEvent(event, ApplicationEvent.Type.APP_ACTIVATED, app, 123L);
    }

    @Override
    @Test
    public void withTime() {
        Application app = this.createApp();
        long before = System.currentTimeMillis();
        ApplicationEvent event = new ApplicationEvent(ApplicationEvent.Type.APP_ACTIVATED, app);
        long after = System.currentTimeMillis();
        ApplicationEventTest.validateEvent(event, ApplicationEvent.Type.APP_ACTIVATED, app, before, after);
    }
}

