/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiLpmFieldMatch;

public class PiLpmFieldMatchTest {
    private final ImmutableByteSequence value1 = ImmutableByteSequence.copyFrom((int)0xA010101);
    private final ImmutableByteSequence value2 = ImmutableByteSequence.copyFrom((int)167837954);
    private int prefixLength = 24;
    private final PiMatchFieldId piMatchField = PiMatchFieldId.of((String)"ipv4_t.dstAddr");
    private PiLpmFieldMatch piLpmFieldMatch1 = new PiLpmFieldMatch(this.piMatchField, this.value1, this.prefixLength);
    private PiLpmFieldMatch sameAsPiLpmFieldMatch1 = new PiLpmFieldMatch(this.piMatchField, this.value1, this.prefixLength);
    private PiLpmFieldMatch piLpmFieldMatch2 = new PiLpmFieldMatch(this.piMatchField, this.value2, this.prefixLength);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiLpmFieldMatch.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piLpmFieldMatch1, this.sameAsPiLpmFieldMatch1}).addEqualityGroup(new Object[]{this.piLpmFieldMatch2}).testEquals();
    }

    @Test
    public void testConstruction() {
        ImmutableByteSequence value = ImmutableByteSequence.copyFrom((int)0xA01010A);
        int prefix = 24;
        PiMatchFieldId piMatchField = PiMatchFieldId.of((String)"ipv4_t.dstAddr");
        PiLpmFieldMatch piLpmFieldMatch = new PiLpmFieldMatch(piMatchField, value, prefix);
        MatcherAssert.assertThat((Object)piLpmFieldMatch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piLpmFieldMatch.value(), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)piLpmFieldMatch.prefixLength(), (Matcher)Matchers.is((Object)prefix));
        MatcherAssert.assertThat((Object)piLpmFieldMatch.type(), (Matcher)Matchers.is((Object)PiMatchType.LPM));
    }
}

