/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.DefaultTopologyEdge;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.TopologyVertex;

public class DefaultTopologyEdgeTest {
    static final DeviceId D1 = DeviceId.deviceId((String)"1");
    static final DeviceId D2 = DeviceId.deviceId((String)"2");
    static final PortNumber P1 = PortNumber.portNumber((long)1L);
    static final PortNumber P2 = PortNumber.portNumber((long)2L);
    static final ConnectPoint CP1 = new ConnectPoint((ElementId)D1, P1);
    static final ConnectPoint CP2 = new ConnectPoint((ElementId)D2, P1);
    static final ConnectPoint CP3 = new ConnectPoint((ElementId)D2, P1);
    static final ConnectPoint CP4 = new ConnectPoint((ElementId)D1, P2);
    static final DefaultTopologyVertex V1 = new DefaultTopologyVertex(D1);
    static final DefaultTopologyVertex V2 = new DefaultTopologyVertex(D2);
    static final ProviderId PID = new ProviderId("foo", "bar");
    static final Link L1 = DefaultLink.builder().providerId(PID).src(CP1).dst(CP2).type(Link.Type.INDIRECT).build();
    static final Link L2 = DefaultLink.builder().providerId(PID).src(CP3).dst(CP4).type(Link.Type.INDIRECT).build();

    @Test
    public void basics() {
        DefaultTopologyEdge e = new DefaultTopologyEdge((TopologyVertex)V1, (TopologyVertex)V2, L1);
        Assert.assertEquals((String)"incorrect src", (Object)V1, (Object)e.src());
        Assert.assertEquals((String)"incorrect dst", (Object)V2, (Object)e.dst());
        Assert.assertEquals((String)"incorrect link", (Object)L1, (Object)e.link());
        new EqualsTester().addEqualityGroup(new Object[]{new DefaultTopologyEdge((TopologyVertex)V1, (TopologyVertex)V2, L1), new DefaultTopologyEdge((TopologyVertex)V1, (TopologyVertex)V2, L1)}).addEqualityGroup(new Object[]{new DefaultTopologyEdge((TopologyVertex)V2, (TopologyVertex)V1, L2), new DefaultTopologyEdge((TopologyVertex)V2, (TopologyVertex)V1, L2)}).testEquals();
    }
}

