/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onosproject.core.ApplicationId;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.AsyncIterator;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentTreeMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class AsyncConsistentTreeMapAdapter<V>
implements AsyncConsistentTreeMap<V> {
    private TreeMap<String, V> map = Maps.newTreeMap();

    private CompletableFuture<Map.Entry<String, Versioned<V>>> makeVersionedEntry(Map.Entry<String, V> entry) {
        return CompletableFuture.completedFuture(new AbstractMap.SimpleImmutableEntry<String, Versioned<V>>(entry.getKey(), this.makeVersioned(entry.getValue())));
    }

    private CompletableFuture<Versioned<V>> makeVersionedFuture(V value) {
        return CompletableFuture.completedFuture(this.makeVersioned(value));
    }

    private Versioned<V> makeVersioned(V value) {
        return new Versioned(value, 1L);
    }

    public CompletableFuture<String> firstKey() {
        return CompletableFuture.completedFuture(this.map.firstKey());
    }

    public CompletableFuture<String> lastKey() {
        return CompletableFuture.completedFuture(this.map.lastKey());
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> ceilingEntry(String key) {
        return this.makeVersionedEntry(this.map.ceilingEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> floorEntry(String key) {
        return this.makeVersionedEntry(this.map.floorEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> higherEntry(String key) {
        return this.makeVersionedEntry(this.map.higherEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> lowerEntry(String key) {
        return this.makeVersionedEntry(this.map.lowerEntry(key));
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> firstEntry() {
        return this.makeVersionedEntry(this.map.firstEntry());
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> lastEntry() {
        return this.makeVersionedEntry(this.map.lastEntry());
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> pollFirstEntry() {
        return this.makeVersionedEntry(this.map.pollFirstEntry());
    }

    public CompletableFuture<Map.Entry<String, Versioned<V>>> pollLastEntry() {
        return this.makeVersionedEntry(this.map.pollLastEntry());
    }

    public CompletableFuture<String> lowerKey(String key) {
        return CompletableFuture.completedFuture(this.map.lowerKey(key));
    }

    public CompletableFuture<String> floorKey(String key) {
        return CompletableFuture.completedFuture(this.map.floorKey(key));
    }

    public CompletableFuture<String> ceilingKey(String key) {
        return CompletableFuture.completedFuture(this.map.ceilingKey(key));
    }

    public CompletableFuture<String> higherKey(String key) {
        return CompletableFuture.completedFuture(this.map.higherKey(key));
    }

    public CompletableFuture<NavigableSet<String>> navigableKeySet() {
        return CompletableFuture.completedFuture(this.map.navigableKeySet());
    }

    public CompletableFuture<NavigableMap<String, V>> subMap(String upperKey, String lowerKey, boolean inclusiveUpper, boolean inclusiveLower) {
        NavigableMap<String, V> subMap = this.map.subMap(upperKey, inclusiveLower, lowerKey, inclusiveLower);
        return CompletableFuture.completedFuture(subMap);
    }

    public ConsistentTreeMap<V> asTreeMap() {
        return null;
    }

    public ConsistentTreeMap<V> asTreeMap(long timeoutMillis) {
        return null;
    }

    public DistributedPrimitive.Type primitiveType() {
        return null;
    }

    public CompletableFuture<Integer> size() {
        return CompletableFuture.completedFuture(this.map.size());
    }

    public CompletableFuture<Boolean> isEmpty() {
        return CompletableFuture.completedFuture(this.map.isEmpty());
    }

    public CompletableFuture<Boolean> containsKey(String key) {
        return CompletableFuture.completedFuture(this.map.containsKey(key));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return CompletableFuture.completedFuture(this.map.containsValue(value));
    }

    public CompletableFuture<Versioned<V>> get(String key) {
        return this.makeVersionedFuture(this.map.get(key));
    }

    public CompletableFuture<Versioned<V>> getOrDefault(String key, V defaultValue) {
        return this.makeVersionedFuture(this.map.getOrDefault(key, defaultValue));
    }

    public CompletableFuture<Versioned<V>> computeIfAbsent(String key, Function<? super String, ? extends V> mappingFunction) {
        return this.makeVersionedFuture(this.map.computeIfAbsent(key, mappingFunction));
    }

    public CompletableFuture<Versioned<V>> computeIfPresent(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return this.makeVersionedFuture(this.map.computeIfPresent(key, remappingFunction));
    }

    public CompletableFuture<Versioned<V>> compute(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return this.makeVersionedFuture(this.map.compute(key, remappingFunction));
    }

    public CompletableFuture<Versioned<V>> computeIf(String key, Predicate<? super V> condition, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        V value = this.map.get(key);
        if (condition.test(value)) {
            value = this.map.compute(key, remappingFunction);
        }
        return this.makeVersionedFuture(value);
    }

    public CompletableFuture<Versioned<V>> put(String key, V value) {
        return this.makeVersionedFuture(this.map.put(key, value));
    }

    public CompletableFuture<Versioned<V>> putAndGet(String key, V value) {
        return this.makeVersionedFuture(this.map.put(key, value));
    }

    public CompletableFuture<Versioned<V>> remove(String key) {
        return this.makeVersionedFuture(this.map.remove(key));
    }

    public CompletableFuture<Void> clear() {
        this.map.clear();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Set<String>> keySet() {
        return CompletableFuture.completedFuture(this.map.keySet());
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        Set valuesAsVersionedCollection = this.map.values().stream().map(this::makeVersioned).collect(Collectors.toSet());
        return CompletableFuture.completedFuture(valuesAsVersionedCollection);
    }

    public CompletableFuture<Set<Map.Entry<String, Versioned<V>>>> entrySet() {
        HashMap valuesAsVersionedMap = new HashMap();
        this.map.forEach((key, value) -> valuesAsVersionedMap.put(key, this.makeVersioned(value)));
        return CompletableFuture.completedFuture(valuesAsVersionedMap.entrySet());
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(String key, V value) {
        return this.makeVersionedFuture(this.map.putIfAbsent(key, value));
    }

    public CompletableFuture<Boolean> remove(String key, V value) {
        return CompletableFuture.completedFuture(this.map.remove(key, value));
    }

    public CompletableFuture<Boolean> remove(String key, long version) {
        V value = this.map.remove(key);
        return CompletableFuture.completedFuture(value != null);
    }

    public CompletableFuture<Versioned<V>> replace(String key, V value) {
        return this.makeVersionedFuture(this.map.replace(key, value));
    }

    public CompletableFuture<Boolean> replace(String key, V oldValue, V newValue) {
        return CompletableFuture.completedFuture(this.map.replace(key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replace(String key, long oldVersion, V newValue) {
        this.map.replace(key, newValue);
        return CompletableFuture.completedFuture(true);
    }

    public CompletableFuture<Void> addListener(MapEventListener<String, V> listener) {
        return null;
    }

    public CompletableFuture<Void> addListener(MapEventListener<String, V> listener, Executor executor) {
        return null;
    }

    public CompletableFuture<Void> removeListener(MapEventListener<String, V> listener) {
        return null;
    }

    public ConsistentMap<String, V> asConsistentMap() {
        return null;
    }

    public ConsistentMap<String, V> asConsistentMap(long timeoutMillis) {
        return null;
    }

    public String name() {
        return null;
    }

    public ApplicationId applicationId() {
        return null;
    }

    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
    }

    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
    }

    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return null;
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        return null;
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<String, V>> transactionLog) {
        return null;
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<String, V>> transactionLog) {
        return null;
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return null;
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return null;
    }

    public CompletableFuture<AsyncIterator<Map.Entry<String, Versioned<V>>>> iterator() {
        return null;
    }
}

