/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime.data;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiData;

@Beta
public final class PiHeader
implements PiData {
    private final Boolean isValid;
    private final ImmutableList<ImmutableByteSequence> bitStrings;

    private PiHeader(Boolean isValid, List<ImmutableByteSequence> bitStrings) {
        this.isValid = isValid;
        this.bitStrings = ImmutableList.copyOf(bitStrings);
    }

    public static PiHeader of(Boolean isValid, List<ImmutableByteSequence> bitStrings) {
        return new PiHeader(isValid, bitStrings);
    }

    public Boolean isValid() {
        return this.isValid;
    }

    public List<ImmutableByteSequence> bitStrings() {
        return this.bitStrings;
    }

    @Override
    public PiData.Type type() {
        return PiData.Type.HEADER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiHeader header = (PiHeader)o;
        return Objects.equal((Object)this.isValid, (Object)header.isValid) && Objects.equal(this.bitStrings, header.bitStrings);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isValid, this.bitStrings});
    }

    public String toString() {
        StringJoiner stringParams = new StringJoiner(", ", "(", ")");
        this.bitStrings().forEach(p -> stringParams.add(p.toString()));
        return MoreObjects.toStringHelper(this.getClass()).add("bitString", (Object)stringParams).add("isValid", (Object)this.isValid).toString();
    }
}

