/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.net.Link;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.BooleanConstraint;

@Beta
public class TierConstraint
extends BooleanConstraint {
    private final List<Integer> tiers;
    private final boolean isInclusive;
    private final CostType costType;

    public TierConstraint(boolean inclusive, CostType costType, Integer ... tiers) {
        Preconditions.checkNotNull((Object)tiers, (Object)"Link tiers cannot be null");
        Preconditions.checkArgument((tiers.length > 0 ? 1 : 0) != 0, (Object)"There must at least one tier");
        if (costType == CostType.ORDER) {
            Preconditions.checkArgument((boolean)inclusive, (Object)"Order is only valid when inclusive=true");
        }
        this.tiers = ImmutableSet.copyOf((Object[])tiers).asList();
        this.isInclusive = inclusive;
        this.costType = costType;
    }

    public TierConstraint(boolean inclusive, Integer ... tiers) {
        this(inclusive, CostType.VALID, tiers);
    }

    private TierConstraint() {
        this.tiers = null;
        this.isInclusive = false;
        this.costType = CostType.VALID;
    }

    @Override
    public boolean isValid(Link link, ResourceContext context) {
        return this.isValid(link);
    }

    private boolean isValid(Link link) {
        boolean contains = link.annotations().keys().contains("tier") && this.tiers.contains(Integer.valueOf(link.annotations().value("tier")));
        return this.isInclusive == contains;
    }

    @Override
    public double cost(Link link, ResourceContext context) {
        return this.cost(link);
    }

    private double cost(Link link) {
        double cost = -1.0;
        if (this.isValid(link)) {
            Integer tier = new Integer(link.annotations().value("tier"));
            cost = this.costType == CostType.ORDER ? (double)(this.tiers.indexOf(tier) + 1) : (this.costType == CostType.TIER ? (double)tier.intValue() : 1.0);
        }
        return cost;
    }

    public List<Integer> tiers() {
        return this.tiers;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    public CostType costType() {
        return this.costType;
    }

    public int hashCode() {
        return Objects.hash(this.tiers, this.isInclusive);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TierConstraint other = (TierConstraint)obj;
        return Objects.equals(this.tiers, other.tiers) && Objects.equals(this.isInclusive, other.isInclusive) && Objects.equals((Object)this.costType, (Object)other.costType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("inclusive", this.isInclusive).add("costType", (Object)this.costType).add("tiers", this.tiers).toString();
    }

    public static enum CostType {
        VALID,
        TIER,
        ORDER;

    }
}

