/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.alarm;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.alarm.Alarm;
import org.onosproject.alarm.AlarmEntityId;
import org.onosproject.alarm.AlarmId;
import org.onosproject.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;

public class DefaultAlarmTest {
    private static final AlarmEntityId ALARM_ENTITY_ID = AlarmEntityId.alarmEntityId((String)"port:bar");
    private static final DeviceId DEVICE_ID = DeviceId.deviceId((String)"foo:bar");
    private static final String UNIQUE_ID_1 = "unique_id_1";
    private static final AlarmId ALARM_ID = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)"unique_id_1");
    private static final String UNIQUE_ID_2 = "unique_id_1";
    private static final AlarmId ALARM_ID_2 = AlarmId.alarmId((DeviceId)DEVICE_ID, (String)"unique_id_1");

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultAlarm.class);
    }

    @Test
    public void testConstruction() {
        DefaultAlarm a = DefaultAlarmTest.generate();
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        DefaultAlarm b = new DefaultAlarm.Builder((Alarm)a).build();
        Assert.assertEquals((Object)a, (Object)b);
    }

    @Test
    public void testEquals() {
        DefaultAlarm a = new DefaultAlarm.Builder(ALARM_ID_2, DeviceId.NONE, "desc", Alarm.SeverityLevel.MINOR, 3L).build();
        DefaultAlarm b = new DefaultAlarm.Builder(ALARM_ID, DeviceId.NONE, "desc", Alarm.SeverityLevel.MINOR, a.timeRaised() + 1L).withTimeUpdated(a.timeUpdated() + 1L).build();
        Assert.assertEquals((String)"id or timeRaised or timeUpdated may differ", (Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)new DefaultAlarm.Builder((Alarm)a).withAcknowledged(!a.acknowledged()).build());
        Assert.assertNotEquals((Object)a, (Object)new DefaultAlarm.Builder((Alarm)a).withManuallyClearable(!a.manuallyClearable()).build());
        Assert.assertNotEquals((Object)a, (Object)new DefaultAlarm.Builder((Alarm)a).withServiceAffecting(!a.serviceAffecting()).build());
        Assert.assertNotEquals((Object)a, (Object)new DefaultAlarm.Builder((Alarm)a).withAssignedUser("Changed" + a.assignedUser()).build());
    }

    @Test
    public void testClear() {
        DefaultAlarm active = DefaultAlarmTest.generate();
        DefaultAlarm cleared = new DefaultAlarm.Builder((Alarm)active).clear().build();
        Assert.assertNotEquals((Object)active, (Object)cleared);
        MatcherAssert.assertThat((Object)cleared.timeRaised(), (Matcher)Matchers.is((Object)active.timeRaised()));
        MatcherAssert.assertThat((Object)cleared.severity(), (Matcher)Matchers.is((Object)Alarm.SeverityLevel.CLEARED));
        MatcherAssert.assertThat((Object)cleared.timeUpdated(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(active.timeUpdated())));
        Assert.assertNotNull((Object)cleared.timeCleared());
    }

    @Test
    public void testId() {
        DefaultAlarm a = DefaultAlarmTest.generate();
        DefaultAlarm b = new DefaultAlarm.Builder((Alarm)a).build();
        Assert.assertEquals((String)"id ignored in equals", (Object)a, (Object)b);
        Assert.assertEquals((Object)ALARM_ID, (Object)a.id());
        Assert.assertEquals((Object)ALARM_ID, (Object)b.id());
        Assert.assertEquals((Object)ALARM_ENTITY_ID, (Object)b.source());
    }

    private static DefaultAlarm generate() {
        return new DefaultAlarm.Builder(ALARM_ID, DeviceId.NONE, "desc", Alarm.SeverityLevel.MINOR, 3L).forSource(ALARM_ENTITY_ID).build();
    }
}

