/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.Link;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.BooleanConstraint;

@Beta
public class MeteredConstraint
extends BooleanConstraint {
    private final boolean useMetered;

    public MeteredConstraint(boolean metered) {
        this.useMetered = metered;
    }

    private MeteredConstraint() {
        this.useMetered = false;
    }

    @Override
    public boolean isValid(Link link, ResourceContext context) {
        return this.isValid(link);
    }

    private boolean isValid(Link link) {
        return !this.isMeteredLink(link) || this.useMetered;
    }

    private boolean isMeteredLink(Link link) {
        return link.annotations().keys().contains("metered") && Boolean.valueOf(link.annotations().value("metered")) != false;
    }

    public boolean isUseMetered() {
        return this.useMetered;
    }

    public int hashCode() {
        return Objects.hash(this.useMetered);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MeteredConstraint other = (MeteredConstraint)obj;
        return Objects.equals(this.useMetered, other.useMetered);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metered", this.useMetered).toString();
    }
}

