/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.host.InterfaceIpAddress;

public class Interface {
    public static final String NO_INTERFACE_NAME = "";
    private final String name;
    private final ConnectPoint connectPoint;
    private final List<InterfaceIpAddress> ipAddresses;
    private final MacAddress macAddress;
    private final VlanId vlan;
    private final VlanId vlanUntagged;
    private final Set<VlanId> vlanTagged;
    private final VlanId vlanNative;

    public Interface(String name, ConnectPoint connectPoint, List<InterfaceIpAddress> ipAddresses, MacAddress macAddress, VlanId vlan) {
        this(name, connectPoint, ipAddresses, macAddress, vlan, null, null, null);
    }

    public Interface(String name, ConnectPoint connectPoint, List<InterfaceIpAddress> ipAddresses, MacAddress macAddress, VlanId vlan, VlanId vlanUntagged, Set<VlanId> vlanTagged, VlanId vlanNative) {
        this.name = name == null ? NO_INTERFACE_NAME : name;
        this.connectPoint = (ConnectPoint)Preconditions.checkNotNull((Object)connectPoint);
        this.ipAddresses = ipAddresses == null ? Lists.newArrayList() : ipAddresses;
        this.macAddress = macAddress == null ? MacAddress.NONE : macAddress;
        this.vlan = vlan == null ? VlanId.NONE : vlan;
        this.vlanUntagged = vlanUntagged == null ? VlanId.NONE : vlanUntagged;
        this.vlanTagged = vlanTagged == null ? ImmutableSet.of() : ImmutableSet.copyOf(vlanTagged);
        this.vlanNative = vlanNative == null ? VlanId.NONE : vlanNative;
    }

    public String name() {
        return this.name;
    }

    public ConnectPoint connectPoint() {
        return this.connectPoint;
    }

    public List<InterfaceIpAddress> ipAddressesList() {
        return this.ipAddresses;
    }

    public MacAddress mac() {
        return this.macAddress;
    }

    public VlanId vlan() {
        return this.vlan;
    }

    public VlanId vlanUntagged() {
        return this.vlanUntagged;
    }

    public Set<VlanId> vlanTagged() {
        return this.vlanTagged;
    }

    public VlanId vlanNative() {
        return this.vlanNative;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Interface)) {
            return false;
        }
        Interface otherInterface = (Interface)other;
        return Objects.equals(this.name, otherInterface.name) && Objects.equals(this.connectPoint, otherInterface.connectPoint) && Objects.equals(this.ipAddresses, otherInterface.ipAddresses) && Objects.equals(this.macAddress, otherInterface.macAddress) && Objects.equals(this.vlan, otherInterface.vlan) && Objects.equals(this.vlanUntagged, otherInterface.vlanUntagged) && Objects.equals(this.vlanTagged, otherInterface.vlanTagged) && Objects.equals(this.vlanNative, otherInterface.vlanNative);
    }

    public int hashCode() {
        return Objects.hash(this.connectPoint, this.name, this.ipAddresses, this.macAddress, this.vlan, this.vlanUntagged, this.vlanTagged, this.vlanNative);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("connectPoint", (Object)this.connectPoint).add("ipAddresses", this.ipAddresses).add("macAddress", (Object)this.macAddress).add("vlan", (Object)this.vlan).add("vlanUntagged", (Object)this.vlanUntagged).add("vlanTagged", this.vlanTagged).add("vlanNative", (Object)this.vlanNative).toString();
    }
}

