/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.ContinuousFactory;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.DiscreteFactory;
import org.onosproject.net.resource.DiscreteResourceId;

@Beta
public final class Resources {
    private Resources() {
    }

    public static DiscreteFactory discrete(DiscreteResourceId id) {
        Preconditions.checkNotNull((Object)id);
        return new DiscreteFactory(id);
    }

    public static DiscreteFactory discrete(DiscreteResourceId parent, Object child) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)child);
        Preconditions.checkArgument((!(child instanceof Class) ? 1 : 0) != 0);
        return new DiscreteFactory(new DiscreteResourceId((ImmutableList<Object>)ImmutableList.builder().addAll(parent.components()).add(child).build()));
    }

    public static DiscreteFactory discrete(DeviceId device) {
        Preconditions.checkNotNull((Object)device);
        return new DiscreteFactory(new DiscreteResourceId((ImmutableList<Object>)ImmutableList.of((Object)device)));
    }

    public static DiscreteFactory discrete(DeviceId device, Object ... components) {
        Preconditions.checkNotNull((Object)device);
        Preconditions.checkNotNull((Object)components);
        return new DiscreteFactory(new DiscreteResourceId((ImmutableList<Object>)ImmutableList.builder().add((Object)device).add(components).build()));
    }

    public static DiscreteFactory discrete(DeviceId device, PortNumber port, Object ... components) {
        Preconditions.checkNotNull((Object)device);
        Preconditions.checkNotNull((Object)port);
        Preconditions.checkNotNull((Object)components);
        return new DiscreteFactory(new DiscreteResourceId((ImmutableList<Object>)ImmutableList.builder().add((Object)device).add((Object)port).add(components).build()));
    }

    static ContinuousFactory continuous(ContinuousResourceId id) {
        Preconditions.checkNotNull((Object)id);
        return new ContinuousFactory(id);
    }

    static ContinuousFactory continuous(DiscreteResourceId parent, Class<?> child) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(child);
        return new ContinuousFactory(new ContinuousResourceId((ImmutableList.Builder<Object>)ImmutableList.builder().addAll(parent.components()), child));
    }

    public static ContinuousFactory continuous(DeviceId device, Class<?> cls) {
        Preconditions.checkNotNull((Object)device);
        Preconditions.checkNotNull(cls);
        return new ContinuousFactory(new ContinuousResourceId((ImmutableList.Builder<Object>)ImmutableList.builder().add((Object)device), cls));
    }

    public static ContinuousFactory continuous(DeviceId device, Object ... components) {
        Preconditions.checkNotNull((Object)device);
        Preconditions.checkNotNull((Object)components);
        Preconditions.checkArgument((components.length > 1 ? 1 : 0) != 0);
        Object last = components[components.length - 1];
        Preconditions.checkArgument((boolean)(last instanceof Class));
        return new ContinuousFactory(new ContinuousResourceId((ImmutableList.Builder<Object>)ImmutableList.builder().add((Object)device).add(Arrays.copyOfRange(components, 0, components.length - 1)), (Class)last));
    }

    public static ContinuousFactory continuous(DeviceId device, PortNumber port, Class<?> cls) {
        Preconditions.checkNotNull((Object)device);
        Preconditions.checkNotNull((Object)port);
        Preconditions.checkNotNull(cls);
        return new ContinuousFactory(new ContinuousResourceId((ImmutableList.Builder<Object>)ImmutableList.builder().add((Object)device).add((Object)port), cls));
    }

    public static ContinuousFactory continuous(DeviceId device, PortNumber port, Object ... components) {
        Preconditions.checkNotNull((Object)device);
        Preconditions.checkNotNull((Object)port);
        Preconditions.checkNotNull((Object)components);
        Preconditions.checkArgument((components.length > 1 ? 1 : 0) != 0);
        Object last = components[components.length - 1];
        Preconditions.checkArgument((boolean)(last instanceof Class));
        return new ContinuousFactory(new ContinuousResourceId((ImmutableList.Builder<Object>)ImmutableList.builder().add((Object)device).add((Object)port).add(Arrays.copyOfRange(components, 0, components.length - 1)), (Class)last));
    }
}

