/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

public final class NodeBadge {
    private static final String EMPTY = "";
    private final Status status;
    private final boolean isGlyph;
    private final String text;
    private final String message;

    private NodeBadge(Status status, boolean isGlyph, String text, String message) {
        this.status = status == null ? Status.INFO : status;
        this.isGlyph = isGlyph;
        this.text = text;
        this.message = message;
    }

    public String toString() {
        return "{Badge " + this.status + " (" + this.text + ")" + (this.isGlyph ? "*G " : " ") + "\"" + this.message + "\"}";
    }

    public Status status() {
        return this.status;
    }

    public boolean isGlyph() {
        return this.isGlyph;
    }

    public String text() {
        return this.text;
    }

    public String message() {
        return this.message;
    }

    private static String nonNull(String s) {
        return s == null ? EMPTY : s;
    }

    public static NodeBadge text(String txt) {
        return new NodeBadge(Status.INFO, false, NodeBadge.nonNull(txt), null);
    }

    public static NodeBadge glyph(String gid) {
        return new NodeBadge(Status.INFO, true, NodeBadge.nonNull(gid), null);
    }

    public static NodeBadge number(int n) {
        return new NodeBadge(Status.INFO, false, Integer.toString(n), null);
    }

    public static NodeBadge text(Status s, String txt) {
        return new NodeBadge(s, false, NodeBadge.nonNull(txt), null);
    }

    public static NodeBadge glyph(Status s, String gid) {
        return new NodeBadge(s, true, NodeBadge.nonNull(gid), null);
    }

    public static NodeBadge number(Status s, int n) {
        return new NodeBadge(s, false, Integer.toString(n), null);
    }

    public static NodeBadge text(Status s, String txt, String msg) {
        return new NodeBadge(s, false, NodeBadge.nonNull(txt), msg);
    }

    public static NodeBadge glyph(Status s, String gid, String msg) {
        return new NodeBadge(s, true, NodeBadge.nonNull(gid), msg);
    }

    public static NodeBadge number(Status s, int n, String msg) {
        return new NodeBadge(s, false, Integer.toString(n), msg);
    }

    public static enum Status {
        INFO("i"),
        WARN("w"),
        ERROR("e");

        private String code;

        private Status(String code) {
            this.code = code;
        }

        public String toString() {
            return "{" + this.code + "}";
        }

        public String code() {
            return this.code;
        }
    }
}

