/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.google.common.collect.Sets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.onosproject.ui.topo.ButtonId;

public class PropertyPanel {
    private static final NumberFormat NF = NumberFormat.getInstance();
    private String title;
    private String glyphId;
    private String id;
    private String navPath;
    private List<Prop> properties = new ArrayList<Prop>();
    private List<ButtonId> buttons = new ArrayList<ButtonId>();

    public PropertyPanel(String title, String glyphId) {
        this.title = title;
        this.glyphId = glyphId;
    }

    protected NumberFormat formatter() {
        return NF;
    }

    public PropertyPanel navPath(String navPath) {
        this.navPath = navPath;
        return this;
    }

    public PropertyPanel id(String id) {
        this.id = id;
        return this;
    }

    public PropertyPanel addProp(String key, String label, String value) {
        this.properties.add(new Prop(key, label, value));
        return this;
    }

    public PropertyPanel addProp(String key, String label, int value) {
        this.properties.add(new Prop(key, label, this.formatter().format(value)));
        return this;
    }

    public PropertyPanel addProp(String key, String label, long value) {
        this.properties.add(new Prop(key, label, this.formatter().format(value)));
        return this;
    }

    public PropertyPanel addProp(String key, String label, Object value) {
        this.properties.add(new Prop(key, label, value.toString()));
        return this;
    }

    public PropertyPanel addProp(String key, String label, Object value, String reStrip) {
        String val = value.toString().replaceAll(reStrip, "");
        this.properties.add(new Prop(key, label, val));
        return this;
    }

    public PropertyPanel addSeparator() {
        this.properties.add(new Separator());
        return this;
    }

    public String title() {
        return this.title;
    }

    public String glyphId() {
        return this.glyphId;
    }

    public String navPath() {
        return this.navPath;
    }

    public String id() {
        return this.id;
    }

    public List<Prop> properties() {
        return this.properties;
    }

    public List<ButtonId> buttons() {
        return this.buttons;
    }

    public PropertyPanel title(String title) {
        this.title = title;
        return this;
    }

    public PropertyPanel glyphId(String glyphId) {
        this.glyphId = glyphId;
        return this;
    }

    public PropertyPanel removeProps(String ... keys) {
        HashSet forRemoval = Sets.newHashSet((Object[])keys);
        ArrayList<Prop> toKeep = new ArrayList<Prop>();
        for (Prop p : this.properties) {
            if (forRemoval.contains(p.key())) continue;
            toKeep.add(p);
        }
        this.properties = toKeep;
        return this;
    }

    public PropertyPanel removeAllProps() {
        this.properties.clear();
        return this;
    }

    public PropertyPanel addButton(ButtonId button) {
        this.buttons.add(button);
        return this;
    }

    public PropertyPanel removeButtons(ButtonId ... descriptors) {
        HashSet forRemoval = Sets.newHashSet((Object[])descriptors);
        ArrayList<ButtonId> toKeep = new ArrayList<ButtonId>();
        for (ButtonId bd : this.buttons) {
            if (forRemoval.contains((Object)bd)) continue;
            toKeep.add(bd);
        }
        this.buttons = toKeep;
        return this;
    }

    public PropertyPanel removeAllButtons() {
        this.buttons.clear();
        return this;
    }

    static class Separator
    extends Prop {
        Separator() {
            super("-", "-", "");
        }
    }

    public static class Prop {
        private final String key;
        private final String label;
        private final String value;

        public Prop(String key, String label, String value) {
            this.key = key;
            this.label = label;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String label() {
            return this.label;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Prop prop = (Prop)o;
            return this.key.equals(prop.key) && this.value.equals(prop.value);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "{" + this.key + "(" + this.label + ") -> " + this.value + "}";
        }
    }
}

