/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.basics.AllowedEntityConfig;

public final class BasicLinkConfig
extends AllowedEntityConfig<LinkKey> {
    public static final String CONFIG_KEY = "basic";
    public static final String TYPE = "type";
    public static final String METRIC = "metric";
    public static final String LATENCY = "latency";
    public static final String BANDWIDTH = "bandwidth";
    public static final String JITTER = "jitter";
    public static final String DELAY = "delay";
    public static final String LOSS = "loss";
    public static final String AVAILABILITY = "availability";
    public static final String TIER = "tier";
    public static final String METERED_USAGE = "meteredUsage";
    public static final String FLAPPING = "flapping";
    public static final String IS_DURABLE = "durable";
    public static final String IS_BIDIRECTIONAL = "bidirectional";
    public static final String IS_METERED = "metered";

    @Override
    public boolean isValid() {
        this.type();
        return this.hasOnlyFields("allowed", TYPE, METRIC, LATENCY, BANDWIDTH, JITTER, DELAY, LOSS, AVAILABILITY, FLAPPING, IS_DURABLE, IS_BIDIRECTIONAL, IS_METERED, TIER, METERED_USAGE) && this.isBoolean("allowed", Config.FieldPresence.OPTIONAL) && this.isNumber(METRIC, Config.FieldPresence.OPTIONAL, new long[0]) && this.isNumber(LATENCY, Config.FieldPresence.OPTIONAL, new long[0]) && this.isNumber(BANDWIDTH, Config.FieldPresence.OPTIONAL, new long[0]) && this.isDecimal(JITTER, Config.FieldPresence.OPTIONAL, new double[0]) && this.isDecimal(DELAY, Config.FieldPresence.OPTIONAL, new double[0]) && this.isDecimal(LOSS, Config.FieldPresence.OPTIONAL, new double[0]) && this.isDecimal(AVAILABILITY, Config.FieldPresence.OPTIONAL, new double[0]) && this.isDecimal(FLAPPING, Config.FieldPresence.OPTIONAL, new double[0]) && this.isNumber(TIER, Config.FieldPresence.OPTIONAL, new long[0]) && this.isDecimal(METERED_USAGE, Config.FieldPresence.OPTIONAL, new double[0]) && this.isBoolean(IS_BIDIRECTIONAL, Config.FieldPresence.OPTIONAL) && this.isBoolean(IS_METERED, Config.FieldPresence.OPTIONAL);
    }

    public boolean isTypeConfigured() {
        return this.hasField(TYPE);
    }

    public Link.Type type() {
        return this.get(TYPE, Link.Type.DIRECT, Link.Type.class);
    }

    public BasicLinkConfig type(Link.Type type) {
        return (BasicLinkConfig)this.setOrClear(TYPE, type);
    }

    public double metric() {
        return this.get(METRIC, -1);
    }

    public BasicLinkConfig metric(Double metric) {
        return (BasicLinkConfig)this.setOrClear(METRIC, metric);
    }

    public Duration latency() {
        return Duration.ofNanos(this.get(LATENCY, -1));
    }

    public BasicLinkConfig latency(Duration latency) {
        Long nanos = latency == null ? null : Long.valueOf(latency.toNanos());
        return (BasicLinkConfig)this.setOrClear(LATENCY, nanos);
    }

    public long bandwidth() {
        return this.get(BANDWIDTH, -1);
    }

    public BasicLinkConfig bandwidth(Long bandwidth) {
        return (BasicLinkConfig)this.setOrClear(BANDWIDTH, bandwidth);
    }

    public Boolean isDurable() {
        JsonNode res = this.object.path(IS_DURABLE);
        if (res.isMissingNode()) {
            return null;
        }
        return res.asBoolean();
    }

    public BasicLinkConfig isDurable(Boolean isDurable) {
        return (BasicLinkConfig)this.setOrClear(IS_DURABLE, isDurable);
    }

    public boolean isBidirectional() {
        JsonNode res = this.object.path(IS_BIDIRECTIONAL);
        if (res.isMissingNode()) {
            return true;
        }
        return res.asBoolean();
    }

    public BasicLinkConfig isBidirectional(Boolean isBidirectional) {
        return (BasicLinkConfig)this.setOrClear(IS_BIDIRECTIONAL, isBidirectional);
    }

    public BasicLinkConfig(LinkKey linkKey) {
        ObjectMapper mapper = new ObjectMapper();
        this.init(linkKey, CONFIG_KEY, (JsonNode)mapper.createObjectNode(), mapper, null);
    }

    public double jitter() {
        return this.get(JITTER, -1.0);
    }

    public BasicLinkConfig jitter(Double jitter) {
        return (BasicLinkConfig)this.setOrClear(JITTER, jitter);
    }

    public double delay() {
        return this.get(DELAY, -1.0);
    }

    public BasicLinkConfig delay(Double delay) {
        return (BasicLinkConfig)this.setOrClear(DELAY, delay);
    }

    public double loss() {
        return this.get(LOSS, -1.0);
    }

    public BasicLinkConfig loss(Double loss) {
        return (BasicLinkConfig)this.setOrClear(LOSS, loss);
    }

    public double availability() {
        return this.get(AVAILABILITY, -1.0);
    }

    public BasicLinkConfig availability(Double availability) {
        return (BasicLinkConfig)this.setOrClear(AVAILABILITY, availability);
    }

    public double flapping() {
        return this.get(FLAPPING, -1.0);
    }

    public BasicLinkConfig flapping(Double flapping) {
        return (BasicLinkConfig)this.setOrClear(FLAPPING, flapping);
    }

    public Boolean isMetered() {
        JsonNode res = this.object.path(IS_METERED);
        if (res.isMissingNode()) {
            return true;
        }
        return res.asBoolean();
    }

    public BasicLinkConfig isMetered(Boolean isMetered) {
        return (BasicLinkConfig)this.setOrClear(IS_METERED, isMetered);
    }

    public long tier() {
        return this.get(TIER, -1);
    }

    public BasicLinkConfig tier(Long tier) {
        return (BasicLinkConfig)this.setOrClear(TIER, tier);
    }

    public double meteredUsage() {
        return this.get(METERED_USAGE, -1.0);
    }

    public BasicLinkConfig meteredUsage(Double meteredUsage) {
        return (BasicLinkConfig)this.setOrClear(METERED_USAGE, meteredUsage);
    }

    public BasicLinkConfig() {
    }
}

