/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.net.PipelineTraceableHitChain;

public final class PipelineTraceableOutput {
    private String log;
    private List<PipelineTraceableHitChain> hitChains;
    private PipelineTraceableResult result;

    private PipelineTraceableOutput(String log, List<PipelineTraceableHitChain> hitChains, PipelineTraceableResult result) {
        this.log = log;
        this.hitChains = hitChains;
        this.result = result;
    }

    public String log() {
        return this.log;
    }

    public List<PipelineTraceableHitChain> hitChains() {
        return this.hitChains;
    }

    public PipelineTraceableResult result() {
        return this.result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PipelineTraceableOutput pipelineTraceableOutput) {
        return new Builder(pipelineTraceableOutput);
    }

    public static final class Builder {
        private StringBuilder log = new StringBuilder();
        private List<PipelineTraceableHitChain> hitChains = Lists.newArrayList();
        private PipelineTraceableResult result = PipelineTraceableResult.SUCCESS;

        private Builder() {
        }

        private Builder(PipelineTraceableOutput traceableOutput) {
            this.appendToLog("\n" + traceableOutput.log());
            this.setResult(traceableOutput.result());
            traceableOutput.hitChains().forEach(this::addHitChain);
        }

        public Builder appendToLog(String message) {
            if (this.log.length() != 0) {
                this.log.append("\n");
            }
            this.log.append(message);
            return this;
        }

        public Builder setResult(PipelineTraceableResult result) {
            if (this.result == PipelineTraceableResult.SUCCESS) {
                this.result = result;
            }
            return this;
        }

        public Builder noFlows() {
            return this.setResult(PipelineTraceableResult.NO_FLOWS);
        }

        public Builder noGroups() {
            return this.setResult(PipelineTraceableResult.NO_GROUPS);
        }

        public Builder noMembers() {
            return this.setResult(PipelineTraceableResult.NO_GROUP_MEMBERS);
        }

        public Builder dropped() {
            return this.setResult(PipelineTraceableResult.DROPPED);
        }

        public Builder addHitChain(PipelineTraceableHitChain hitChain) {
            if (!this.hitChains.contains(hitChain)) {
                this.hitChains.add(hitChain);
            }
            return this;
        }

        public PipelineTraceableOutput build() {
            return new PipelineTraceableOutput(this.log.toString(), this.hitChains, this.result);
        }
    }

    public static enum PipelineTraceableResult {
        SUCCESS,
        NO_FLOWS,
        NO_GROUPS,
        NO_GROUP_MEMBERS,
        DROPPED;

    }
}

