/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.util;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;

public final class IntentMiniSummary {
    private String intentType;
    private int total = 0;
    private int installReq = 0;
    private int compiling = 0;
    private int installing = 0;
    private int installed = 0;
    private int recompiling = 0;
    private int withdrawReq = 0;
    private int withdrawing = 0;
    private int withdrawn = 0;
    private int failed = 0;
    private int unknownState = 0;

    IntentMiniSummary(Intent intent, IntentService intentService) {
        this.intentType = IntentMiniSummary.intentType(intent);
        this.update(intentService.getIntentState(intent.key()));
    }

    IntentMiniSummary(String intentType) {
        this.intentType = intentType;
    }

    public IntentMiniSummary() {
    }

    private static String intentType(Intent intent) {
        return intent.getClass().getSimpleName().replace("Intent", "");
    }

    public String getIntentType() {
        return this.intentType;
    }

    public int getTotal() {
        return this.total;
    }

    public int getInstallReq() {
        return this.installReq;
    }

    public int getCompiling() {
        return this.compiling;
    }

    public int getInstalling() {
        return this.installing;
    }

    public int getInstalled() {
        return this.installed;
    }

    public int getRecompiling() {
        return this.recompiling;
    }

    public int getWithdrawReq() {
        return this.withdrawReq;
    }

    public int getWithdrawing() {
        return this.withdrawing;
    }

    public int getWithdrawn() {
        return this.withdrawn;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getUnknownState() {
        return this.unknownState;
    }

    public void update(IntentState intentState) {
        ++this.total;
        switch (intentState) {
            case INSTALL_REQ: {
                ++this.installReq;
                break;
            }
            case COMPILING: {
                ++this.compiling;
                break;
            }
            case INSTALLING: {
                ++this.installing;
                break;
            }
            case INSTALLED: {
                ++this.installed;
                break;
            }
            case RECOMPILING: {
                ++this.recompiling;
                break;
            }
            case WITHDRAW_REQ: {
                ++this.withdrawReq;
                break;
            }
            case WITHDRAWING: {
                ++this.withdrawing;
                break;
            }
            case WITHDRAWN: {
                ++this.withdrawn;
                break;
            }
            case FAILED: {
                ++this.failed;
                break;
            }
            default: {
                ++this.unknownState;
            }
        }
    }

    public Map<String, IntentMiniSummary> summarize(Iterable<Intent> intents, IntentService intentService) {
        Map<String, List<Intent>> perIntent = Tools.stream(intents).collect(Collectors.groupingBy(IntentMiniSummary::intentType));
        List<IntentMiniSummary> collect = perIntent.values().stream().map(il -> il.stream().map(intent -> new IntentMiniSummary((Intent)intent, intentService)).reduce(new IntentMiniSummary(), this::merge)).collect(Collectors.toList());
        HashMap<String, IntentMiniSummary> summaries = new HashMap<String, IntentMiniSummary>();
        collect.forEach(is -> summaries.put(is.intentType, (IntentMiniSummary)is));
        summaries.put("All", collect.stream().reduce(new IntentMiniSummary("All"), this::merge));
        return summaries;
    }

    IntentMiniSummary merge(IntentMiniSummary a, IntentMiniSummary b) {
        IntentMiniSummary m = new IntentMiniSummary((String)MoreObjects.firstNonNull((Object)a.getIntentType(), (Object)b.getIntentType()));
        m.total = a.total + b.total;
        m.installReq = a.installReq + b.installReq;
        m.compiling = a.compiling + b.compiling;
        m.installing = a.installing + b.installing;
        m.installed = a.installed + b.installed;
        m.recompiling = a.recompiling + b.recompiling;
        m.withdrawing = a.withdrawing + b.withdrawing;
        m.withdrawReq = a.withdrawReq + b.withdrawReq;
        m.withdrawn = a.withdrawn + b.withdrawn;
        m.failed = a.failed + b.failed;
        m.unknownState = a.unknownState + b.unknownState;
        return m;
    }
}

