/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.app;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.onosproject.app.ApplicationDescription;
import org.onosproject.core.ApplicationRole;
import org.onosproject.core.Version;
import org.onosproject.security.Permission;

public final class DefaultApplicationDescription
implements ApplicationDescription {
    private final String name;
    private final Version version;
    private final String title;
    private final String description;
    private final String origin;
    private final String category;
    private final String url;
    private final String readme;
    private final byte[] icon;
    private final ApplicationRole role;
    private final Set<Permission> permissions;
    private final Optional<URI> featuresRepo;
    private final List<String> features;
    private final List<String> requiredApps;

    private DefaultApplicationDescription() {
        throw new UnsupportedOperationException();
    }

    private DefaultApplicationDescription(String name, Version version, String title, String description, String origin, String category, String url, String readme, byte[] icon, ApplicationRole role, Set<Permission> permissions, URI featuresRepo, List<String> features, List<String> requiredApps) {
        this.name = name;
        this.version = version;
        this.title = title;
        this.description = description;
        this.origin = origin;
        this.category = category;
        this.url = url;
        this.readme = readme;
        this.icon = icon;
        this.role = role;
        this.permissions = permissions;
        this.featuresRepo = Optional.ofNullable(featuresRepo);
        this.features = ImmutableList.copyOf(features);
        this.requiredApps = ImmutableList.copyOf(requiredApps);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String category() {
        return this.category;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String readme() {
        return this.readme;
    }

    @Override
    public byte[] icon() {
        return this.icon;
    }

    @Override
    public String origin() {
        return this.origin;
    }

    @Override
    public ApplicationRole role() {
        return this.role;
    }

    @Override
    public Set<Permission> permissions() {
        return this.permissions;
    }

    @Override
    public Optional<URI> featuresRepo() {
        return this.featuresRepo;
    }

    @Override
    public List<String> features() {
        return this.features;
    }

    @Override
    public List<String> requiredApps() {
        return this.requiredApps;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("version", (Object)this.version).add("description", (Object)this.description).add("title", (Object)this.title).add("origin", (Object)this.origin).add("category", (Object)this.category).add("url", (Object)this.url).add("readme", (Object)this.readme).add("role", (Object)this.role).add("permissions", this.permissions).add("featuresRepo", this.featuresRepo).add("features", this.features).add("requiredApps", this.requiredApps).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Version version;
        private String title;
        private String description;
        private String category;
        private String url;
        private String readme;
        private byte[] icon;
        private String origin;
        private ApplicationRole role;
        private Set<Permission> permissions;
        private URI featuresRepo;
        private List<String> features;
        private List<String> requiredApps;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withReadme(String readme) {
            this.readme = readme;
            return this;
        }

        public Builder withIcon(byte[] icon) {
            this.icon = icon;
            return this;
        }

        public Builder withOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        public Builder withRole(ApplicationRole role) {
            this.role = role;
            return this;
        }

        public Builder withPermissions(Set<Permission> permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder withFeaturesRepo(URI featuresRepo) {
            this.featuresRepo = featuresRepo;
            return this;
        }

        public Builder withFeatures(List<String> features) {
            this.features = features;
            return this;
        }

        public Builder withRequiredApps(List<String> requiredApps) {
            this.requiredApps = requiredApps;
            return this;
        }

        public DefaultApplicationDescription build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"Name cannot be null");
            Preconditions.checkNotNull((Object)this.version, (Object)"Version cannot be null");
            Preconditions.checkNotNull((Object)this.title, (Object)"Title cannot be null");
            Preconditions.checkNotNull((Object)this.description, (Object)"Description cannot be null");
            Preconditions.checkNotNull((Object)this.origin, (Object)"Origin cannot be null");
            Preconditions.checkNotNull((Object)this.category, (Object)"Category cannot be null");
            Preconditions.checkNotNull((Object)this.readme, (Object)"Readme cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.role), (Object)"Role cannot be null");
            Preconditions.checkNotNull(this.permissions, (Object)"Permissions cannot be null");
            Preconditions.checkNotNull(this.features, (Object)"Features cannot be null");
            Preconditions.checkNotNull(this.requiredApps, (Object)"Required apps cannot be null");
            Preconditions.checkArgument((!this.features.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one feature");
            return new DefaultApplicationDescription(this.name, this.version, this.title, this.description, this.origin, this.category, this.url, this.readme, this.icon, this.role, this.permissions, this.featuresRepo, this.features, this.requiredApps);
        }
    }
}

