/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import java.util.Objects;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.group.Group;
import org.onosproject.net.pi.service.PiTranslatable;

public class DataPlaneEntity {
    private FlowEntry flowEntry;
    private Group groupEntry;
    private Type type;

    public DataPlaneEntity(FlowEntry flow) {
        this.flowEntry = flow;
        this.type = Type.FLOWRULE;
    }

    public DataPlaneEntity(Group group) {
        this.groupEntry = group;
        this.type = Type.GROUP;
    }

    public FlowEntry getFlowEntry() {
        return this.flowEntry;
    }

    public Group getGroupEntry() {
        return this.groupEntry;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type == Type.FLOWRULE ? this.flowEntry.hashCode() : this.groupEntry.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataPlaneEntity) {
            DataPlaneEntity that = (DataPlaneEntity)obj;
            if (this.type == that.type) {
                return Objects.equals(this.flowEntry, that.flowEntry) && Objects.equals(this.groupEntry, that.groupEntry);
            }
        }
        return false;
    }

    public String toString() {
        PiTranslatable entity = this.type == Type.FLOWRULE ? this.flowEntry : this.groupEntry;
        return "DataPlaneEntity{entity=" + entity + "}";
    }

    public static enum Type {
        FLOWRULE,
        GROUP;

    }
}

