/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class PortDescriptionsConfig
extends Config<DeviceId> {
    private static Logger log = LoggerFactory.getLogger(PortDescriptionsConfig.class);
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ENABLED = "enabled";
    private static final String REMOVED = "removed";
    private static final String TYPE = "type";
    private static final String SPEED = "speed";
    private static final String ANNOTATIONS = "annotations";
    private static final String CONFIG_VALUE_ERROR = "Error parsing config value";

    @Override
    public boolean isValid() {
        Iterator it = this.node.fields();
        while (it.hasNext()) {
            JsonNode nodePort = (JsonNode)((Map.Entry)it.next()).getValue();
            if (!this.hasOnlyFields((ObjectNode)nodePort, NUMBER, NAME, ENABLED, REMOVED, TYPE, SPEED, ANNOTATIONS)) {
                return false;
            }
            ObjectNode obj = (ObjectNode)nodePort;
            if (!(this.isNumber(obj, NUMBER, Config.FieldPresence.MANDATORY, new long[0]) && this.isString(obj, NAME, Config.FieldPresence.OPTIONAL, new String[0]) && this.isBoolean(obj, ENABLED, Config.FieldPresence.OPTIONAL) && this.isBoolean(obj, REMOVED, Config.FieldPresence.OPTIONAL) && this.isString(obj, TYPE, Config.FieldPresence.OPTIONAL, new String[0]) && this.isIntegralNumber(obj, SPEED, Config.FieldPresence.OPTIONAL, new long[0]))) {
                return false;
            }
            if (!this.node.has(ANNOTATIONS) || this.node.get(ANNOTATIONS).isObject()) continue;
            log.error("Annotations must be an inner json node");
            return false;
        }
        return true;
    }

    public List<PortDescription> portDescriptions() {
        try {
            ImmutableList.Builder portDescriptions = ImmutableList.builder();
            Iterator it = this.node.fields();
            while (it.hasNext()) {
                JsonNode portNode = (JsonNode)((Map.Entry)it.next()).getValue();
                long number = portNode.path(NUMBER).asLong();
                String name = portNode.path(NAME).asText(null);
                PortNumber portNumber = this.createPortNumber(number, name);
                DefaultPortDescription.Builder builder = DefaultPortDescription.builder().withPortNumber(portNumber);
                if (portNode.has(ENABLED)) {
                    builder.isEnabled(portNode.path(ENABLED).asBoolean());
                }
                if (portNode.has(REMOVED)) {
                    builder.isRemoved(portNode.path(REMOVED).asBoolean());
                }
                if (portNode.has(TYPE)) {
                    builder.type(Port.Type.valueOf(portNode.path(TYPE).asText().toUpperCase()));
                }
                if (portNode.has(SPEED)) {
                    builder.portSpeed(portNode.path(SPEED).asLong());
                }
                if (portNode.has(ANNOTATIONS)) {
                    DefaultAnnotations.Builder annotationsBuilder = DefaultAnnotations.builder();
                    Iterator annotationsIt = portNode.get(ANNOTATIONS).fields();
                    while (annotationsIt.hasNext()) {
                        Map.Entry entry = (Map.Entry)annotationsIt.next();
                        annotationsBuilder.set((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
                    }
                    builder.annotations(annotationsBuilder.build());
                }
                portDescriptions.add((Object)builder.build());
            }
            return portDescriptions.build();
        }
        catch (IllegalArgumentException e) {
            log.error(CONFIG_VALUE_ERROR, (Throwable)e);
            return ImmutableList.of();
        }
    }

    private PortNumber createPortNumber(long number, String name) {
        if (name == null) {
            return PortNumber.portNumber(number);
        }
        return PortNumber.portNumber(number, name);
    }
}

